/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.aliens;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.infinitylib.common.Events;
import javax.annotation.Nonnull;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class Firestorm
extends Alien<Blaze>
implements Listener {
    public Firestorm(@NonNull String id, @NonNull String name, double maxHealth, int spawnChance) {
        super(Blaze.class, id, name, maxHealth, spawnChance);
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Events.registerListener(this);
    }

    @Override
    public void onShoot(@Nonnull ProjectileLaunchEvent e) {
        e.getEntity().setMetadata("electrified", (MetadataValue)new FixedMetadataValue((Plugin)Galactifun.instance(), (Object)true));
    }

    @Override
    public void onDamage(@Nonnull EntityDamageEvent e) {
        if (e.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onFireballHit(ProjectileHitEvent e) {
        Projectile projectile = e.getEntity();
        if (projectile.hasMetadata("electrified")) {
            projectile.getWorld().strikeLightning(projectile.getLocation());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onPlayerDeath(PlayerDeathEvent e) {
        Component msg = e.deathMessage();
        if (msg == null) {
            return;
        }
        String s = PlainTextComponentSerializer.plainText().serialize(msg);
        if (s.endsWith(" was struck by lightning whilst fighting Firestorm")) {
            e.deathMessage((Component)Component.text((String)(e.getEntity().getName() + " was electrocuted by Firestorm")));
        }
    }

    @Override
    protected boolean canSpawnInLightLevel(int lightLevel) {
        return true;
    }
}

