/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import com.google.common.collect.Iterables;
import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.core.managers.WorldManager;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Marker;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;

public abstract class PlanetaryWorld
extends PlanetaryObject {
    private static final NamespacedKey WORLD_STORAGE_KEY = Galactifun.createKey("world_storage");
    private World world;
    private WorldManager worldManager;
    private SlimefunAddon addon;
    private Marker worldStorage;
    private final Set<GEOResource> resources = new HashSet<GEOResource>();

    public PlanetaryWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public PlanetaryWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public final void register(@Nonnull SlimefunAddon addon) {
        if (this.isRegistered()) {
            throw new IllegalStateException("World already registered!");
        }
        this.worldManager = Galactifun.worldManager();
        this.addon = addon;
        this.world = this.loadWorld();
        if (this.world != null) {
            this.worldManager.register(this);
            Collection markers = this.world.getNearbyEntitiesByType(Marker.class, new Location(this.world, 0.0, 0.0, 0.0), 0.1, e -> e.getPersistentDataContainer().has(WORLD_STORAGE_KEY, PersistentDataType.STRING));
            if (markers.isEmpty()) {
                this.worldStorage = (Marker)this.world.spawn(new Location(this.world, 0.0, 0.0, 0.0), Marker.class);
                PersistentDataAPI.setString((PersistentDataHolder)this.worldStorage, (NamespacedKey)WORLD_STORAGE_KEY, (String)"");
            } else {
                this.worldStorage = (Marker)Iterables.get((Iterable)markers, (int)0);
            }
        }
    }

    public final boolean isRegistered() {
        return this.worldManager != null;
    }

    @Nullable
    protected abstract World loadWorld();

    @Nonnull
    public final PersistentDataHolder worldStorage() {
        Validate.notNull((Object)this.worldStorage, (String)("Attempted to get the world storage of disabled world " + this.name()));
        return this.worldStorage;
    }

    public final boolean enabled() {
        return this.world != null;
    }

    public void registerGEOResource(GEOResource resource) {
        this.resources.add(resource);
    }

    public World world() {
        return this.world;
    }

    public SlimefunAddon addon() {
        return this.addon;
    }

    public Set<GEOResource> resources() {
        return this.resources;
    }
}

