/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.types;

import com.google.common.collect.ImmutableSet;
import io.github.addoncommunity.galactifun.api.universe.types.UniversalType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class GalaxyType
extends UniversalType {
    public static final Map<String, GalaxyType> allTypes = new HashMap<String, GalaxyType>();
    public static final GalaxyType ELLIPTICAL = new GalaxyType("Elliptical", "ELLIPTICAL");
    public static final GalaxyType SPIRAL = new GalaxyType("Spiral", "SPIRAL");
    public static final GalaxyType IRREGULAR = new GalaxyType("Irregular", "IRREGULAR");

    public GalaxyType(String name, String id) {
        super(name, id);
        allTypes.put(id, this);
    }

    public static GalaxyType getById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return allTypes.get(id);
    }

    @Nonnull
    public static Set<GalaxyType> allTypes() {
        return ImmutableSet.copyOf(allTypes.values());
    }
}

