/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.structures;

import javax.annotation.Nonnull;
import org.bukkit.block.BlockFace;

public enum StructureRotation {
    DEFAULT,
    CLOCKWISE,
    OPPOSITE,
    COUNTER_CLOCKWISE;

    private static final StructureRotation[] ROTATIONS;
    private static final BlockFace[] FACES;

    @Nonnull
    public StructureRotation rotationTo(@Nonnull StructureRotation rotation) {
        return ROTATIONS[Math.abs(rotation.ordinal() - this.ordinal())];
    }

    @Nonnull
    public BlockFace rotateFace(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> FACES[this.ordinal()];
            case BlockFace.EAST -> FACES[this.ordinal() + 1];
            case BlockFace.SOUTH -> FACES[this.ordinal() + 2];
            case BlockFace.WEST -> FACES[this.ordinal() + 3];
            default -> face;
        };
    }

    @Nonnull
    public static StructureRotation fromFace(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> DEFAULT;
            case BlockFace.EAST -> CLOCKWISE;
            case BlockFace.SOUTH -> OPPOSITE;
            case BlockFace.WEST -> COUNTER_CLOCKWISE;
            default -> throw new IllegalArgumentException("BlockFace " + face + " cant be converted to StructureRotation!");
        };
    }

    static {
        ROTATIONS = StructureRotation.values();
        FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH};
    }
}

