/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class Util {
    public static final double KM_PER_LY = 9.461E12;
    public static final Pattern COORD_PATTERN = Pattern.compile("^-?\\d+ -?\\d+$");
    public static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    public static final BlockFace[] SURROUNDING_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    public static final Set<Material> IMPERMEABLE_BLOCKS = EnumSet.noneOf(Material.class);
    public static final BlockFace[] ALL_SIDES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    @Nonnull
    public static String timeSince(double nanoTime) {
        nanoTime = (double)System.nanoTime() - nanoTime;
        if (nanoTime >= 1.0E9) {
            return (int)(nanoTime / 1000000.0) / 1000 + " s";
        }
        return (double)((int)(nanoTime / 1000.0)) / 1000.0 + " ms";
    }

    @Nonnull
    public static Optional<Set<BlockPosition>> floodFill(@NonNull Location start, int max) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (max == 0) {
            return Optional.empty();
        }
        HashSet<Block> visited = new HashSet<Block>();
        ArrayDeque<Block> queue = new ArrayDeque<Block>();
        queue.add(start.getBlock());
        while (!queue.isEmpty()) {
            if (visited.size() > max) {
                return Optional.empty();
            }
            Block next = (Block)queue.remove();
            visited.add(next);
            for (BlockFace face : ALL_SIDES) {
                Block b = next.getRelative(face);
                if (IMPERMEABLE_BLOCKS.contains(b.getType()) || visited.contains(b) || queue.contains(b)) continue;
                queue.add(b);
            }
        }
        return Optional.of(visited.parallelStream().map(BlockPosition::new).collect(Collectors.toSet()));
    }

    public static Location getHighestBlockAt(@NonNull RegionAccessor region, int x, int z) {
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        for (int y = 0; y < 319; ++y) {
            if (!region.getType(x, y, z).isAir()) continue;
            return new Location(null, (double)x, (double)(y - 1), (double)z);
        }
        return new Location(null, (double)x, 0.0, (double)z);
    }

    public static Block getHighestBlockAt(@NonNull World world, int x, int z, @NonNull Predicate<Block> isSolid) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        if (isSolid == null) {
            throw new NullPointerException("isSolid is marked non-null but is null");
        }
        for (int y = world.getMaxHeight() - 1; y > world.getMinHeight(); --y) {
            Block block = world.getBlockAt(x, y, z);
            if (!isSolid.test(block)) continue;
            return world.getBlockAt(x, y + 1, z);
        }
        return world.getBlockAt(x, 0, z);
    }

    public static String formatDistance(double distance) {
        if (distance >= 0.25) {
            return "%.3f ly".formatted(distance);
        }
        return "%.3f km".formatted(distance * 9.461E12);
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.GLASS_BLOCKS.getValues());
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.TERRACOTTA.getValues());
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.UNBREAKABLE_MATERIALS.getValues());
        IMPERMEABLE_BLOCKS.addAll(Arrays.asList(Material.IRON_DOOR, Material.IRON_TRAPDOOR, Material.OBSIDIAN, Material.IRON_BLOCK, Material.GOLD_BLOCK, Material.DIAMOND_BLOCK, Material.NETHERITE_BLOCK, Material.SEA_LANTERN, Material.QUARTZ_BLOCK, Material.SMOOTH_QUARTZ));
        for (Material material : Material.values()) {
            if (!material.name().startsWith("WAXED") && !material.name().endsWith("CONCRETE")) continue;
            IMPERMEABLE_BLOCKS.add(material);
        }
    }
}

