/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import com.google.common.util.concurrent.AtomicDouble;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.fastutil.objects.ObjectIntPair;
import io.github.addoncommunity.galactifun.util.GenUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public abstract class SimpleAlienWorld
extends AlienWorld {
    private volatile SimplexOctaveGenerator generator;
    private volatile SimplexOctaveGenerator craterGenerator;
    private final AtomicDouble craterDepthNoise = new AtomicDouble(0.0);
    private volatile CraterSettings craterSettings;

    public SimpleAlienWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public SimpleAlienWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    protected final void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        ObjectIntPair<Material> top = this.getTop();
        int heightSub = top == null ? 0 : top.rightInt();
        int x = 0;
        int realX = chunkX << 4;
        while (x < 16) {
            int z = 0;
            int realZ = chunkZ << 4;
            while (z < 16) {
                int height = this.getHeight(world, realX, realZ) - heightSub;
                int y = 1;
                while (y <= height) {
                    chunk.setBlock(x, y++, z, this.generateMaterial(random, x, y, z, height));
                }
                this.generateMore(chunk, this.generator, random, realX, realZ, x, z, height);
                ++z;
                ++realZ;
            }
            ++x;
            ++realX;
        }
    }

    @Override
    protected final void generateSurface(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        ObjectIntPair<Material> top = this.getTop();
        if (top != null) {
            Material material = (Material)top.left();
            int height = top.rightInt();
            int x = 0;
            int realX = chunkX << 4;
            while (x < 16) {
                int z = 0;
                int realZ = chunkZ << 4;
                while (z < 16) {
                    int topY;
                    for (int y = topY = this.getHeight(world, realX, realZ); y > topY - height; --y) {
                        chunk.setBlock(x, y, z, material);
                    }
                    ++z;
                    ++realZ;
                }
                ++x;
                ++realX;
            }
        }
    }

    private int getHeight(WorldInfo info, int x, int z) {
        double temp;
        if (this.generator == null) {
            this.generator = new SimplexOctaveGenerator(info.getSeed(), this.getOctaves());
            this.generator.setScale(this.getScale());
        }
        if (this.craterDepthNoise.get() != -1.0 && this.craterSettings == null) {
            this.craterSettings = this.getCraterSettings();
            if (this.craterSettings != null) {
                this.craterDepthNoise.set(1.0 - this.craterSettings.noiseDepth());
            } else {
                this.craterDepthNoise.set(-1.0);
            }
        }
        if (this.craterGenerator == null && this.craterSettings != null) {
            this.craterGenerator = new SimplexOctaveGenerator(info.getSeed(), this.craterSettings.octaves());
            this.craterGenerator.setScale(this.craterSettings.scale());
        }
        double noise = this.generator.noise((double)x, (double)z, this.getFrequency(), this.getAmplitude(), true);
        if (this.smoothenTerrain()) {
            noise *= noise;
        }
        if (this.craterDepthNoise.get() != -1.0) {
            double craterNoise = this.craterGenerator.noise((double)x, (double)z, this.craterSettings.frequency(), this.craterSettings.amplitude(), true);
            if ((craterNoise += this.craterDepthNoise.get()) < 0.0) {
                noise += craterNoise;
            }
        }
        return (temp = (double)this.getAverageHeight() + (double)this.getMaxDeviation() * noise) >= 0.0 ? (int)temp : (int)temp - 1;
    }

    @Nonnull
    protected abstract Material generateMaterial(@Nonnull Random var1, int var2, int var3, int var4, int var5);

    @Nullable
    protected ObjectIntPair<Material> getTop() {
        return null;
    }

    @Nullable
    protected CraterSettings getCraterSettings() {
        return null;
    }

    @Nonnull
    protected abstract Biome getBiome();

    @Override
    @Nonnull
    protected final BiomeProvider getBiomeProvider(@Nonnull WorldInfo info) {
        return new GenUtils.SingleBiomeProvider(this.getBiome());
    }

    protected void generateMore(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull SimplexOctaveGenerator generator, @Nonnull Random random, int realX, int realZ, int x, int z, int height) {
    }

    protected int getAverageHeight() {
        return 75;
    }

    protected int getMaxDeviation() {
        return 35;
    }

    protected int getOctaves() {
        return 8;
    }

    protected double getScale() {
        return 0.01;
    }

    protected double getAmplitude() {
        return 0.5;
    }

    protected double getFrequency() {
        return 0.5;
    }

    protected boolean smoothenTerrain() {
        return false;
    }

    protected record CraterSettings(int octaves, double scale, double frequency, double amplitude, double noiseDepth) {
        public static CraterSettings DEFAULT = new CraterSettings(3, 0.01, 0.5, 0.1, 0.35);
    }
}

