/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.core.managers;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.bukkit.Location;

public final class ProtectionManager {
    private final Map<BlockPosition, Map<AtmosphericEffect, Integer>> protectedBlocks = new HashMap<BlockPosition, Map<AtmosphericEffect, Integer>>();
    private final Set<BlockPosition> oxygen = new HashSet<BlockPosition>();

    @Nonnull
    public Map<AtmosphericEffect, Integer> protectionsAt(@Nonnull Location l) {
        return this.protectedBlocks.getOrDefault(new BlockPosition(l), new HashMap());
    }

    public int protectionAt(@Nonnull Location l, @Nonnull AtmosphericEffect effect) {
        return this.protectionsAt(l).getOrDefault(effect, 0);
    }

    public void addProtection(@Nonnull BlockPosition pos, @Nonnull AtmosphericEffect effect, int level) {
        this.protectedBlocks.computeIfAbsent(pos, k -> new HashMap()).merge(effect, level, Integer::sum);
    }

    @Deprecated
    public void clearProtectedBlocks() {
        this.protectedBlocks.clear();
    }

    @Nonnull
    public Map<AtmosphericEffect, Integer> getEffectsAt(@Nonnull Location l) {
        AlienWorld world = Galactifun.worldManager().getAlienWorld(l.getWorld());
        if (world == null) {
            return new HashMap<AtmosphericEffect, Integer>();
        }
        return this.subtractProtections(world.atmosphere(), this.protectionsAt(l));
    }

    public int getEffectAt(@Nonnull Location l, @Nonnull AtmosphericEffect effect) {
        return this.getEffectsAt(l).getOrDefault(effect, 0);
    }

    @Nonnull
    public Map<AtmosphericEffect, Integer> subtractProtections(@NonNull Atmosphere atmosphere, @NonNull Map<AtmosphericEffect, Integer> protections) {
        if (atmosphere == null) {
            throw new NullPointerException("atmosphere is marked non-null but is null");
        }
        if (protections == null) {
            throw new NullPointerException("protections is marked non-null but is null");
        }
        HashMap<AtmosphericEffect, Integer> ret = new HashMap<AtmosphericEffect, Integer>();
        for (Map.Entry<AtmosphericEffect, Integer> eff : atmosphere.effects().entrySet()) {
            int val = eff.getValue() - protections.getOrDefault(eff.getKey(), 0);
            if (val <= 0) continue;
            ret.put(eff.getKey(), val);
        }
        return ret;
    }

    public void addOxygenBlock(@Nonnull BlockPosition l) {
        this.oxygen.add(l);
    }

    public boolean isOxygenBlock(@Nonnull Location l) {
        return this.oxygen.contains(new BlockPosition(l));
    }

    @Deprecated
    public void clearOxygenBlocks() {
        this.oxygen.clear();
    }
}

