/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.types;

import com.google.common.collect.ImmutableSet;
import io.github.addoncommunity.galactifun.api.universe.types.UniversalType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class StarSystemType
extends UniversalType {
    private static final Map<String, StarSystemType> allTypes = new HashMap<String, StarSystemType>();
    public static final StarSystemType NORMAL = new StarSystemType("Normal", "NORMAL");
    public static final StarSystemType BINARY = new StarSystemType("Binary", "BINARY");

    public StarSystemType(String name, String id) {
        super(name, id);
        allTypes.put(id, this);
    }

    public static StarSystemType getById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return allTypes.get(id);
    }

    @Nonnull
    public static Set<StarSystemType> allTypes() {
        return ImmutableSet.copyOf(allTypes.values());
    }
}

