/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.types;

import com.google.common.collect.ImmutableSet;
import io.github.addoncommunity.galactifun.api.universe.types.UniversalType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class PlanetaryType
extends UniversalType {
    private static final Map<String, PlanetaryType> allTypes = new HashMap<String, PlanetaryType>();
    public static final PlanetaryType SPACE = new PlanetaryType("Space", "SPACE");
    public static final PlanetaryType GAS_GIANT = new PlanetaryType("Gas giant", "GAS_GIANT");
    public static final PlanetaryType FROZEN = new PlanetaryType("Frozen", "FROZEN");
    public static final PlanetaryType OCEANIC = new PlanetaryType("Oceanic", "OCEANIC");
    public static final PlanetaryType TERRESTRIAL = new PlanetaryType("Terrestrial", "TERRESTRIAL");
    public static final PlanetaryType UNKNOWN = new PlanetaryType("Unknown", "UNKNOWN");

    public PlanetaryType(String name, String id) {
        super(name, id);
        allTypes.put(id, this);
    }

    public static PlanetaryType getById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return allTypes.get(id);
    }

    @Nonnull
    public static Set<PlanetaryType> allTypes() {
        return ImmutableSet.copyOf(allTypes.values());
    }
}

