/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.items;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.base.items.LaunchPadCore;
import io.github.addoncommunity.galactifun.base.items.knowledge.KnowledgeLevel;
import io.github.addoncommunity.galactifun.core.WorldSelector;
import io.github.addoncommunity.galactifun.core.managers.WorldManager;
import io.github.addoncommunity.galactifun.infinitylib.common.PersistentType;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import io.github.addoncommunity.galactifun.infinitylib.common.StackUtils;
import io.github.addoncommunity.galactifun.util.Util;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class Rocket
extends SlimefunItem {
    public static final NamespacedKey CARGO_KEY = Galactifun.createKey("cargo");
    private static final List<String> LAUNCH_MESSAGES = Galactifun.instance().getConfig().getStringList("rockets.launch-msgs");
    private static final double DISTANCE_PER_FUEL = 2.113941443822006E-7;
    private final int fuelCapacity;
    private final int storageCapacity;
    private final Set<String> allowedFuels;

    public Rocket(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, int fuelCapacity, int storageCapacity) {
        super(category, item, recipeType, recipe);
        this.fuelCapacity = fuelCapacity;
        this.storageCapacity = storageCapacity;
        this.allowedFuels = this.getAllowedFuels().stream().map(StackUtils::getIdOrType).collect(Collectors.toUnmodifiableSet());
        this.addItemHandler(new ItemHandler[]{e -> e.getClickedBlock().ifPresent(block -> {
            e.cancel();
            this.openGUI(e.getPlayer(), (Block)block);
        })});
        this.addItemHandler(new ItemHandler[]{new BlockPlaceHandler(false){

            public void onPlayerPlace(@Nonnull BlockPlaceEvent e) {
                Block b = e.getBlock();
                BlockData data = b.getBlockData();
                if (data instanceof Rotatable) {
                    ((Rotatable)data).setRotation(BlockFace.NORTH);
                }
                b.setBlockData(data, true);
            }
        }});
    }

    private static Runnable sendRandomMessage(Player p) {
        return () -> p.sendMessage(ChatColor.GOLD + LAUNCH_MESSAGES.get(ThreadLocalRandom.current().nextInt(LAUNCH_MESSAGES.size())) + "...");
    }

    private void openGUI(@Nonnull Player p, @Nonnull Block b) {
        if (!BlockStorage.check((Block)b, (String)this.getId())) {
            return;
        }
        String string = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"isLaunching");
        if (Boolean.parseBoolean(string)) {
            p.sendMessage(ChatColor.RED + "The rocket is already launching!");
            return;
        }
        WorldManager worldManager = Galactifun.worldManager();
        PlanetaryWorld world = worldManager.getWorld(p.getWorld());
        if (world == null) {
            p.sendMessage(ChatColor.RED + "You cannot travel to space from this world!");
            return;
        }
        string = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fuel");
        if (string == null) {
            return;
        }
        int fuel = Integer.parseInt(string);
        if (fuel == 0) {
            p.sendMessage(ChatColor.RED + "The rocket has no fuel!");
            return;
        }
        string = BlockStorage.getLocationInfo((Location)b.getLocation(), (String)"fuelType");
        if (string == null) {
            return;
        }
        String fuelType = string;
        Double eff = LaunchPadCore.FUELS.get(string);
        if (eff == null) {
            return;
        }
        double maxDistance = (double)fuel * 2.113941443822006E-7 * eff;
        new WorldSelector((player, obj, lore) -> {
            if (obj instanceof PlanetaryWorld) {
                double dist = obj.distanceTo(world);
                if (dist > maxDistance) {
                    return false;
                }
                lore.add(Component.empty());
                lore.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.text((String)"Distance: "))).append((Component)Component.text((long)((long)Math.ceil(dist / 9.461E12))))).build());
                lore.add(((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.text((String)"Fuel: "))).append((Component)Component.text((long)((long)Math.ceil(dist / (2.113941443822006E-7 * eff)))))).build());
            }
            return true;
        }, (player, pw) -> {
            player.closeInventory();
            long usedFuel = (long)Math.ceil(pw.distanceTo(world) / (2.113941443822006E-7 * eff));
            player.sendMessage(ChatColor.YELLOW + "You are going to " + pw.name() + " and will use " + usedFuel + " fuel. Are you sure you want to do that? (yes/no)");
            ChatUtils.awaitInput((Player)player, input -> {
                if (input.equalsIgnoreCase("yes")) {
                    p.sendMessage(ChatColor.YELLOW + "Please enter destination coordinates in the form of <x> <z> (i.e. -123 456):");
                    ChatUtils.awaitInput((Player)p, response -> {
                        String trimmed = response.trim();
                        if (Util.COORD_PATTERN.matcher(trimmed).matches()) {
                            String[] split = Util.SPACE_PATTERN.split(trimmed);
                            int x = Integer.parseInt(split[0]);
                            int z = Integer.parseInt(split[1]);
                            this.launch(player, b, pw, (long)fuel - usedFuel, fuelType, x, z);
                        } else {
                            p.sendMessage(ChatColor.RED + "Invalid coordinate format! Please use the format <x> <z>");
                        }
                    });
                }
            });
        }).open(p);
    }

    public void launch(@Nonnull Player p, final @Nonnull Block rocket, PlanetaryWorld worldTo, long fuelLeft, String fuelType, int x, int z) {
        BlockStorage.addBlockInfo((Block)rocket, (String)"isLaunching", (String)"true");
        final World world = p.getWorld();
        new BukkitRunnable(){
            private final Block pad;
            private int times;
            {
                this.pad = rocket.getRelative(BlockFace.DOWN);
                this.times = 0;
            }

            public void run() {
                if (this.times++ < 20) {
                    for (BlockFace face : Util.SURROUNDING_FACES) {
                        Block block = this.pad.getRelative(face);
                        world.spawnParticle(Particle.ASH, block.getLocation(), 100, 0.5, 0.5, 0.5);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Galactifun.instance(), 0L, 10L);
        World to = worldTo.world();
        Chunk destChunk = to.getChunkAt(x >> 4, z >> 4);
        if (!destChunk.isLoaded()) {
            destChunk.load(true);
        }
        Scheduler.run(40, Rocket.sendRandomMessage(p));
        Scheduler.run(80, Rocket.sendRandomMessage(p));
        Scheduler.run(120, Rocket.sendRandomMessage(p));
        Scheduler.run(160, Rocket.sendRandomMessage(p));
        Scheduler.run(200, () -> {
            p.sendMessage(ChatColor.GOLD + "Verifying blast awesomeness...");
            Block destBlock = null;
            for (int y = to.getMaxHeight(); y > to.getMinHeight(); --y) {
                Block b = to.getBlockAt(x, y, z);
                if (!b.isSolid() || BlockStorage.check((Block)b, (String)BaseItems.LANDING_HATCH.getItemId())) continue;
                destBlock = b.getRelative(BlockFace.UP);
                break;
            }
            if (destBlock == null) {
                destBlock = to.getBlockAt(x, to.getMaxHeight() - 4, z);
            }
            if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, destBlock, Interaction.PLACE_BLOCK)) {
                p.sendMessage(ChatColor.RED + "Launch was not successful! You do not have permission to land there!");
                BlockStorage.addBlockInfo((Block)rocket, (String)"isLaunching", (String)"false");
                return;
            }
            destBlock.setType(Material.CHEST);
            BlockState state = PaperLib.getBlockState((Block)destBlock, (boolean)false).getState();
            if (state instanceof Chest) {
                Chest chest = (Chest)state;
                Inventory inv = chest.getInventory();
                inv.addItem(new ItemStack[]{this.getItem().clone()});
                ItemStack fuel = StackUtils.itemByIdOrType(fuelType);
                fuel = fuel.clone();
                fuel.setAmount((int)fuelLeft);
                inv.addItem(new ItemStack[]{fuel});
                PersistentDataContainer container = ((Skull)rocket.getState()).getPersistentDataContainer();
                List cargo = (List)container.getOrDefault(CARGO_KEY, PersistentType.ITEM_STACK_LIST, new ArrayList());
                for (ItemStack item : cargo) {
                    HashMap notFit = inv.addItem(new ItemStack[]{item});
                    for (ItemStack nf : notFit.values()) {
                        to.dropItemNaturally(destBlock.getLocation().add(0.0, 1.0, 0.0), nf);
                    }
                }
            }
            state.update();
            boolean showLaunchAnimation = false;
            for (Entity entity : world.getEntities()) {
                if ((!(entity instanceof LivingEntity) || entity instanceof ArmorStand) && !(entity instanceof Item)) continue;
                if (entity.getLocation().distanceSquared(rocket.getLocation()) <= 25.0) {
                    if (entity instanceof Player) {
                        entity.setMetadata("CanTpAlienWorld", (MetadataValue)new FixedMetadataValue((Plugin)Galactifun.instance(), (Object)true));
                    }
                    PaperLib.teleportAsync((Entity)entity, (Location)destBlock.getLocation().add(0.0, 1.0, 0.0));
                    if (KnowledgeLevel.get(p, worldTo) != KnowledgeLevel.NONE) continue;
                    KnowledgeLevel.BASIC.set(p, worldTo);
                    continue;
                }
                if (!(entity.getLocation().distance(rocket.getLocation()) <= 64.0) || !(entity instanceof Player)) continue;
                showLaunchAnimation = true;
            }
            if (showLaunchAnimation) {
                final Location rocketLocation = rocket.getLocation().add(0.5, -1.0, 0.5);
                final ArmorStand armorStand = (ArmorStand)rocketLocation.getWorld().spawn(rocketLocation, ArmorStand.class);
                Skull skull = (Skull)rocket.getState();
                ItemStack stack = new ItemStack(skull.getType());
                stack.editMeta(meta -> ((SkullMeta)meta).setPlayerProfile(skull.getPlayerProfile()));
                armorStand.getEquipment().setHelmet(stack);
                armorStand.setInvisible(true);
                armorStand.setInvulnerable(true);
                armorStand.setMarker(false);
                armorStand.setBasePlate(false);
                new BukkitRunnable(){
                    int i = 0;

                    public void run() {
                        ++this.i;
                        armorStand.setVelocity(new Vector(0.0, 0.8 + (double)this.i / 10.0, 0.0));
                        rocketLocation.getWorld().spawnParticle(Rocket.this.getLaunchParticles(), armorStand.getLocation(), 10);
                        if (this.i > 40) {
                            armorStand.remove();
                            this.cancel();
                        }
                    }
                }.runTaskTimer((Plugin)Galactifun.instance(), 0L, 8L);
            }
            rocket.setType(Material.AIR);
            BlockStorage.clearBlockInfo((Block)rocket);
        });
    }

    protected abstract List<ItemStack> getAllowedFuels();

    @Nonnull
    protected Particle getLaunchParticles() {
        return Particle.ASH;
    }

    public int fuelCapacity() {
        return this.fuelCapacity;
    }

    public int storageCapacity() {
        return this.storageCapacity;
    }

    public Set<String> allowedFuels() {
        return this.allowedFuels;
    }
}

