/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.core.commands;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.items.knowledge.KnowledgeLevel;
import io.github.addoncommunity.galactifun.infinitylib.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.List;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class GalactiportCommand
extends SubCommand {
    public GalactiportCommand() {
        super("world", "Teleports you to the spawn of the specified world", true);
    }

    @Override
    public void execute(@Nonnull CommandSender commandSender, @Nonnull String[] strings) {
        Player p;
        block6: {
            block5: {
                if (!(commandSender instanceof Player)) break block5;
                p = (Player)commandSender;
                if (strings.length == 1) break block6;
            }
            return;
        }
        World world = Bukkit.getWorld((String)strings[0]);
        if (world == null) {
            p.sendMessage(ChatColor.RED + "Invalid World!");
            return;
        }
        PaperLib.teleportAsync((Entity)p, (Location)world.getSpawnLocation());
        PlanetaryWorld planetaryWorld = Galactifun.worldManager().getWorld(world);
        if (planetaryWorld != null && KnowledgeLevel.get(p, planetaryWorld) == KnowledgeLevel.NONE) {
            KnowledgeLevel.BASIC.set(p, planetaryWorld);
        }
    }

    @Override
    public void complete(@Nonnull CommandSender commandSender, @Nonnull String[] strings, @Nonnull List<String> worlds) {
        if (strings.length == 1) {
            for (World world : Bukkit.getWorlds()) {
                worlds.add(world.getName());
            }
        }
    }
}

