/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.infinitylib.common;

import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

@ParametersAreNonnullByDefault
public final class PersistentType<T, Z>
implements PersistentDataType<T, Z> {
    public static final PersistentDataType<byte[], ItemStack> ITEM_STACK = new PersistentType<byte[], ItemStack>(byte[].class, ItemStack.class, itemStack -> {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)bytes);){
            output.writeObject(itemStack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes.toByteArray();
    }, arr -> {
        ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])arr);
        try (BukkitObjectInputStream input = new BukkitObjectInputStream((InputStream)bytes);){
            ItemStack itemStack = (ItemStack)input.readObject();
            return itemStack;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CustomItemStack(Material.STONE, "&cERROR", new String[0]);
        }
    });
    public static final PersistentDataType<byte[], List<ItemStack>> ITEM_STACK_LIST = new PersistentType<byte[], List>(byte[].class, List.class, list -> {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)bytes);){
            for (ItemStack item : list) {
                output.writeObject((Object)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes.toByteArray();
    }, arr -> {
        ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])arr);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        try (BukkitObjectInputStream input = new BukkitObjectInputStream((InputStream)bytes);){
            while (bytes.available() > 0) {
                list.add((ItemStack)input.readObject());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    });
    public static final PersistentDataType<byte[], Location> LOCATION = new PersistentType<byte[], Location>(byte[].class, Location.class, location -> {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream output = new BukkitObjectOutputStream((OutputStream)bytes);){
            output.writeObject(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes.toByteArray();
    }, arr -> {
        ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])arr);
        try (BukkitObjectInputStream input = new BukkitObjectInputStream((InputStream)bytes);){
            Location location = (Location)input.readObject();
            return location;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Location(null, 0.0, 0.0, 0.0);
        }
    });
    public static final PersistentDataType<byte[], List<String>> STRING_LIST = new PersistentType<byte[], List>(byte[].class, List.class, list -> {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(list.size() * 20);
        for (String string : list) {
            byte[] arr = string.getBytes();
            bytes.write(arr.length);
            bytes.write(arr, 0, arr.length);
        }
        return bytes.toByteArray();
    }, arr -> {
        ByteArrayInputStream bytes = new ByteArrayInputStream((byte[])arr);
        ArrayList<String> list = new ArrayList<String>(((byte[])arr).length / 20);
        try {
            while (bytes.available() > 0) {
                byte[] string = new byte[bytes.read()];
                bytes.read(string, 0, string.length);
                list.add(new String(string));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    });
    @Deprecated
    public static final PersistentDataType<String, ItemStack> ITEM_STACK_OLD = new PersistentType<String, ItemStack>(String.class, ItemStack.class, itemStack -> {
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", itemStack);
        return config.saveToString();
    }, string -> {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(string);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
            return new CustomItemStack(Material.STONE, "&cERROR", new String[0]);
        }
        ItemStack item = config.getItemStack("item");
        return item != null ? item : new CustomItemStack(Material.STONE, "&cERROR", new String[0]);
    });
    private final Class<T> primitive;
    private final Class<Z> complex;
    private final Function<Z, T> toPrimitive;
    private final Function<T, Z> toComplex;

    @Nonnull
    public Class<T> getPrimitiveType() {
        return this.primitive;
    }

    @Nonnull
    public Class<Z> getComplexType() {
        return this.complex;
    }

    @Nonnull
    public T toPrimitive(Z complex, PersistentDataAdapterContext context) {
        return this.toPrimitive.apply(complex);
    }

    @Nonnull
    public Z fromPrimitive(T primitive, PersistentDataAdapterContext context) {
        return this.toComplex.apply(primitive);
    }

    public PersistentType(Class<T> primitive, Class<Z> complex, Function<Z, T> toPrimitive, Function<T, Z> toComplex) {
        this.primitive = primitive;
        this.complex = complex;
        this.toPrimitive = toPrimitive;
        this.toComplex = toComplex;
    }
}

