/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.items.spacesuit;

import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuit;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitStat;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitUpgrade;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@ParametersAreNonnullByDefault
public final class SpaceSuitProfile {
    private static final Map<UUID, SpaceSuitProfile> profiles = new HashMap<UUID, SpaceSuitProfile>();
    private static final double OXYGEN_PER_TICK = 0.05;
    private final Map<SpaceSuitStat, Integer> stats = new HashMap<SpaceSuitStat, Integer>();
    private final int[] oxygen = new int[4];
    private final int[] oxygenChanged = new int[4];

    @Nonnull
    public static SpaceSuitProfile get(Player p) {
        return profiles.computeIfAbsent(p.getUniqueId(), uuid -> {
            SpaceSuitProfile profile = new SpaceSuitProfile();
            profile.update(p);
            return profile;
        });
    }

    private static void updateAll() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isValid() || p.isDead()) continue;
            SpaceSuitProfile.get(p).update(p);
        }
    }

    public boolean consumeOxygen(int ticksSinceLastBreath) {
        int consume = (int)((double)ticksSinceLastBreath * 0.05);
        for (int i = 0; i < 4; ++i) {
            int slot = this.oxygenChanged[i];
            if (slot >= consume) {
                int n = i;
                this.oxygenChanged[n] = this.oxygenChanged[n] - consume;
                return true;
            }
            if (slot == 0) continue;
            consume -= slot;
            this.oxygenChanged[i] = 0;
        }
        return false;
    }

    public int getStat(SpaceSuitStat stat) {
        return this.stats.getOrDefault(stat, 0);
    }

    private void update(Player p) {
        this.stats.clear();
        ItemStack[] armorContents = p.getInventory().getArmorContents();
        int armorContentsLength = armorContents.length;
        for (int i = 0; i < armorContentsLength; ++i) {
            ItemStack item = armorContents[i];
            if (item == null || item.getType().isAir() || !item.hasItemMeta()) continue;
            ItemMeta meta = item.getItemMeta();
            SpaceSuitUpgrade.getUpgrades(meta, this.stats);
            this.oxygenChanged[i] = this.oxygen[i] = SpaceSuit.getOxygen(item, meta, this.oxygenChanged[i] - this.oxygen[i]);
        }
    }

    private SpaceSuitProfile() {
    }

    static {
        Scheduler.repeat(200, SpaceSuitProfile::updateAll);
    }
}

