/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items;

import io.github.addoncommunity.galactifun.api.items.Relic;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.fastutil.ints.IntIntPair;
import io.github.addoncommunity.galactifun.infinitylib.machines.AbstractMachineBlock;
import io.github.addoncommunity.galactifun.infinitylib.machines.MenuBlock;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineProcessHolder;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import io.github.thebusybiscuit.slimefun4.core.machines.MachineProcessor;
import io.github.thebusybiscuit.slimefun4.implementation.operations.CraftingOperation;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class TechnologicalSalvager
extends AbstractMachineBlock
implements MachineProcessHolder<CraftingOperation> {
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 4, 13, 31, 36, 37, 38, 39, 40};
    private static final int[] INPUT_BORDER = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] INPUT_SLOTS = new int[]{19, 20};
    private static final int[] OUTPUT_BORDER = new int[]{5, 6, 7, 8, 14, 17, 23, 26, 32, 35, 41, 42, 43, 44};
    private static final int[] OUTPUT_SLOTS = new int[]{15, 16, 24, 25, 33, 34};
    private static final ItemStack ANALYZING = new CustomItemStack(Material.LIME_STAINED_GLASS_PANE, "&aAnalyzing...", new String[0]);
    private final MachineProcessor<CraftingOperation> processor = new MachineProcessor((MachineProcessHolder)this);

    public TechnologicalSalvager(SlimefunItemStack item, ItemStack[] recipe) {
        super(CoreItemGroup.MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.energyPerTick(32);
        this.energyCapacity(64);
    }

    @Override
    protected boolean process(@Nonnull Block b, @Nonnull BlockMenu menu) {
        CraftingOperation operation = (CraftingOperation)this.processor.getOperation(b);
        if (operation != null) {
            if (operation.isFinished()) {
                ItemStack[] results;
                for (ItemStack result : results = operation.getResults()) {
                    menu.pushItem(result, OUTPUT_SLOTS);
                }
                this.processor.endOperation(b);
            } else {
                operation.addProgress(1);
            }
            return true;
        }
        for (int i : INPUT_SLOTS) {
            ItemStack item = menu.getItemInSlot(i);
            SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)item);
            if (!(slimefunItem instanceof Relic)) continue;
            Relic relic = (Relic)slimefunItem;
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (Map.Entry<ItemStack, IntIntPair> entry : relic.required().entrySet()) {
                int amount = ThreadLocalRandom.current().nextInt(entry.getValue().leftInt(), entry.getValue().rightInt() + 1);
                if (amount <= 0) continue;
                results.add(entry.getKey().asQuantity(amount));
            }
            if (ThreadLocalRandom.current().nextDouble() < (double)relic.optionals().sumWeights()) {
                results.add((ItemStack)relic.optionals().getRandom());
            }
            menu.replaceExistingItem(this.getStatusSlot(), ANALYZING);
            this.processor.startOperation(b, (MachineOperation)new CraftingOperation(new ItemStack[]{item}, (ItemStack[])results.toArray(ItemStack[]::new), 240));
            menu.consumeItem(i);
            return true;
        }
        menu.replaceExistingItem(this.getStatusSlot(), MenuBlock.IDLE_ITEM);
        return false;
    }

    @Override
    protected int getStatusSlot() {
        return 22;
    }

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        preset.drawBackground(BACKGROUND);
        for (int i : INPUT_BORDER) {
            preset.addItem(i, MenuBlock.INPUT_BORDER, ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, MenuBlock.OUTPUT_BORDER, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    protected int[] getInputSlots() {
        return INPUT_SLOTS;
    }

    @Override
    protected int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Nonnull
    public MachineProcessor<CraftingOperation> getMachineProcessor() {
        return this.processor;
    }
}

