/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;

public abstract class AlienWorld
extends PlanetaryWorld {
    public static final NamespacedKey CHUNK_VER_KEY = Galactifun.createKey("chunk_version");
    private final Map<Material, SlimefunItemStack> blockMappings = new EnumMap<Material, SlimefunItemStack>(Material.class);
    private final List<Alien<?>> species = new ArrayList();

    public AlienWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public AlienWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    @Nullable
    protected World loadWorld() {
        if (!this.getSetting("enabled", Boolean.class, this.enabledByDefault()).booleanValue()) {
            return null;
        }
        Galactifun.log(Level.INFO, "Loading planet " + this.name());
        String worldName = "world_galactifun_" + this.id;
        World world = new WorldCreator(worldName).generator(this.replaceChunkGenerator(new ChunkGenerator(){

            @Nullable
            public BiomeProvider getDefaultBiomeProvider(@Nonnull WorldInfo worldInfo) {
                return AlienWorld.this.getBiomeProvider(worldInfo);
            }

            public void generateBedrock(@Nonnull WorldInfo worldInfo, @Nonnull Random random, int chunkX, int chunkZ, @Nonnull ChunkGenerator.ChunkData chunkData) {
                int bedrock = AlienWorld.this.getBedrockLayer();
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        chunkData.setBlock(x, bedrock, z, Material.BEDROCK);
                    }
                }
            }

            public void generateNoise(@Nonnull WorldInfo worldInfo, @Nonnull Random random, int x, int z, @Nonnull ChunkGenerator.ChunkData chunkData) {
                AlienWorld.this.generateChunk(chunkData, random, worldInfo, x, z);
            }

            public void generateSurface(@Nonnull WorldInfo worldInfo, @Nonnull Random random, int x, int z, @Nonnull ChunkGenerator.ChunkData chunkData) {
                AlienWorld.this.generateSurface(chunkData, random, worldInfo, x, z);
            }

            @Nonnull
            public List<BlockPopulator> getDefaultPopulators(@Nonnull World world) {
                ArrayList<BlockPopulator> list = new ArrayList<BlockPopulator>(1);
                AlienWorld.this.getPopulators(list);
                return list;
            }
        })).environment(this.atmosphere().environment()).createWorld();
        Validate.notNull((Object)world, (String)("There was an error loading the world for " + worldName));
        if (world.getEnvironment() == World.Environment.THE_END) {
            world.getBlockAt(0, 0, 0).setType(Material.END_PORTAL);
            world.getBlockAt(0, 1, 0).setType(Material.BEDROCK);
            world.getBlockAt(1, 0, 0).setType(Material.BEDROCK);
            world.getBlockAt(-1, 0, 0).setType(Material.BEDROCK);
            world.getBlockAt(0, 0, 1).setType(Material.BEDROCK);
            world.getBlockAt(0, 0, -1).setType(Material.BEDROCK);
        }
        this.dayCycle().applyEffects(world);
        this.atmosphere().applyEffects(world);
        return world;
    }

    public final void addSpecies(Alien<?> ... aliens) {
        for (Alien<?> alien : aliens) {
            if (!alien.isRegistered()) {
                throw new IllegalStateException("You must register an alien before adding it to a world!");
            }
            this.species.add(alien);
        }
    }

    protected final <T> T getSetting(@Nonnull String path, @Nonnull Class<T> clazz, T defaultValue) {
        return Galactifun.worldManager().getSetting(this, path, clazz, defaultValue);
    }

    public final void addBlockMapping(@Nonnull Material vanillaItem, @Nonnull SlimefunItemStack slimefunItem) {
        this.blockMappings.put(vanillaItem, slimefunItem);
    }

    @Nullable
    public SlimefunItemStack getMappedItem(Block b) {
        return this.blockMappings.get(b.getType());
    }

    public boolean canSpawnVanillaMobs() {
        return false;
    }

    protected boolean enabledByDefault() {
        return true;
    }

    @Deprecated
    protected void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull ChunkGenerator.BiomeGrid grid, @Nonnull Random random, @Nonnull World world, int chunkX, int chunkZ) {
    }

    protected abstract void generateChunk(@Nonnull ChunkGenerator.ChunkData var1, @Nonnull Random var2, @Nonnull WorldInfo var3, int var4, int var5);

    protected void generateSurface(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
    }

    protected abstract void getPopulators(@Nonnull List<BlockPopulator> var1);

    @Nullable
    protected BiomeProvider getBiomeProvider(@Nonnull WorldInfo info) {
        return null;
    }

    @Nonnull
    protected ChunkGenerator replaceChunkGenerator(@Nonnull ChunkGenerator defaultGenerator) {
        return defaultGenerator;
    }

    protected int getBedrockLayer() {
        return 0;
    }

    public final void applyEffects(@Nonnull Player p) {
        this.atmosphere().applyEffects(p);
    }

    public final void tickWorld() {
        block4: {
            World world = this.world();
            this.dayCycle().tick(world);
            for (Player p : world.getPlayers()) {
                this.gravity().applyGravity(p);
                if (p.getGameMode() != GameMode.SURVIVAL) continue;
                this.applyEffects(p);
            }
            this.dayCycle().tick(world);
            if (this.species.isEmpty() || world.getPlayers().isEmpty()) break block4;
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            Collections.shuffle(this.species, rand);
            int players = world.getPlayers().size();
            int mobs = 0;
            for (LivingEntity e : world.getLivingEntities()) {
                if (Galactifun.alienManager().getAlien((Entity)e) == null) continue;
                ++mobs;
            }
            int max = players * Galactifun.worldManager().maxAliensPerPlayer();
            if (mobs < max) {
                for (Alien<?> alien : this.species) {
                    if ((mobs += alien.attemptSpawn(rand, world)) > max) break;
                }
            }
        }
    }
}

