/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.universe.saturn;

import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.api.worlds.populators.LakePopulator;
import io.github.addoncommunity.galactifun.api.worlds.populators.OrePopulator;
import io.github.addoncommunity.galactifun.base.BaseMats;
import io.github.addoncommunity.galactifun.base.universe.saturn.TitanBiome;
import io.github.addoncommunity.galactifun.base.universe.saturn.TitanBiomeProvider;
import io.github.addoncommunity.galactifun.util.Util;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public final class Titan
extends AlienWorld {
    private volatile SimplexOctaveGenerator generator;
    private volatile TitanBiomeProvider provider;

    public Titan(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    protected void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        this.init(world);
        int x = 0;
        int realX = chunkX << 4;
        while (x < 16) {
            int z = 0;
            int realZ = chunkZ << 4;
            while (z < 16) {
                int height = this.getHeight(realX, realZ);
                for (int y = 0; y < height; ++y) {
                    if (random.nextBoolean()) {
                        chunk.setBlock(x, y, z, Material.STONE);
                        continue;
                    }
                    chunk.setBlock(x, y, z, Material.COAL_ORE);
                }
                ++z;
                ++realZ;
            }
            ++x;
            ++realX;
        }
    }

    @Override
    protected void generateSurface(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull Random random, @Nonnull WorldInfo world, int chunkX, int chunkZ) {
        this.init(world);
        int x = 0;
        int realX = chunkX << 4;
        while (x < 16) {
            int z = 0;
            int realZ = chunkZ << 4;
            while (z < 16) {
                Material material;
                int height = this.getHeight(realX, realZ);
                TitanBiome biome = this.provider.getBiome(world, realX, realZ);
                if (height < 57) {
                    material = Material.BLUE_ICE;
                } else {
                    switch (biome) {
                        case FOREST: {
                            if (random.nextBoolean()) {
                                material = Material.WARPED_NYLIUM;
                                break;
                            }
                            material = Material.CRIMSON_NYLIUM;
                            break;
                        }
                        case FROZEN_FOREST: {
                            material = Material.WARPED_NYLIUM;
                            break;
                        }
                        case WASTELAND: {
                            material = Material.SAND;
                            break;
                        }
                        case DRY_ICE_FLATS: {
                            material = Material.PACKED_ICE;
                            break;
                        }
                        case CARBON_FOREST: 
                        case FROZEN_CARBON_FOREST: {
                            material = Material.COAL_BLOCK;
                            break;
                        }
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                    }
                }
                Material material2 = material;
                chunk.setBlock(x, height, z, material2);
                if (height > 56) {
                    if (biome == TitanBiome.CARBON_FOREST) {
                        if (random.nextDouble() < 0.1) {
                            for (y = height + random.nextInt(4); y > height; --y) {
                                chunk.setBlock(x, y, z, Material.COAL_BLOCK);
                            }
                        }
                    } else if (biome == TitanBiome.FROZEN_CARBON_FOREST && random.nextDouble() < 0.1) {
                        for (y = height + random.nextInt(4); y > height; --y) {
                            if (random.nextBoolean()) {
                                chunk.setBlock(x, y, z, Material.PACKED_ICE);
                                continue;
                            }
                            chunk.setBlock(x, y, z, Material.COAL_BLOCK);
                        }
                    }
                }
                ++z;
                ++realZ;
            }
            ++x;
            ++realX;
        }
    }

    @Override
    @Nonnull
    protected BiomeProvider getBiomeProvider(@Nonnull WorldInfo info) {
        this.init(info);
        return this.provider;
    }

    private void init(@Nonnull WorldInfo info) {
        if (this.generator == null) {
            this.generator = new SimplexOctaveGenerator(info.getSeed(), 8);
            this.generator.setScale(0.004);
        }
        if (this.provider == null) {
            this.provider = new TitanBiomeProvider();
        }
    }

    int getHeight(int x, int z) {
        double startHeight = this.generator.noise((double)x, (double)z, 0.5, 0.5, true);
        return (int)(55.0 + 30.0 * (startHeight * startHeight));
    }

    @Override
    public void getPopulators(@Nonnull List<BlockPopulator> populators) {
        populators.add(new BlockPopulator(){

            public void populate(@Nonnull WorldInfo worldInfo, @Nonnull Random random, int cx, int cz, @Nonnull LimitedRegion region) {
                int amount = random.nextInt(2) + 1;
                for (int i = 0; i < amount; ++i) {
                    int z;
                    int x = (cx << 4) + random.nextInt(16);
                    if (region.getBiome(x, 1, z = (cz << 4) + random.nextInt(16)) != TitanBiome.FOREST.biome()) continue;
                    Location l = Util.getHighestBlockAt((RegionAccessor)region, x, z);
                    if (region.getType(l) == Material.WARPED_NYLIUM) {
                        region.generateTree(l.add(0.0, 1.0, 0.0), random, TreeType.WARPED_FUNGUS);
                        continue;
                    }
                    region.generateTree(l.add(0.0, 1.0, 0.0), random, TreeType.CRIMSON_FUNGUS);
                }
            }
        });
        populators.add(new BlockPopulator(){

            public void populate(@Nonnull WorldInfo worldInfo, @Nonnull Random random, int cx, int cz, @Nonnull LimitedRegion region) {
                int z;
                int x;
                if (random.nextDouble() < 0.25 && region.getBiome(x = (cx << 4) + random.nextInt(16), 1, z = (cz << 4) + random.nextInt(16)) == TitanBiome.FROZEN_FOREST.biome()) {
                    Location l = Util.getHighestBlockAt((RegionAccessor)region, x, z).add(0.0, 1.0, 0.0);
                    region.generateTree(l, random, TreeType.WARPED_FUNGUS);
                }
            }
        });
        populators.add(new OrePopulator(1, 50, 1, 40, 2, 6, BaseMats.LASERITE_ORE, Material.STONE, Material.COAL_ORE));
        populators.add(new LakePopulator(58, Material.WATER));
    }
}

