/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere;

import com.google.common.primitives.Ints;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitStat;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class AtmosphericEffect {
    private static final Map<String, AtmosphericEffect> allEffects = new HashMap<String, AtmosphericEffect>();
    public static final AtmosphericEffect RADIATION = new AtmosphericEffect("RADIATION", SpaceSuitStat.RADIATION_RESISTANCE, PotionEffectType.WITHER);
    public static final AtmosphericEffect HEAT = new AtmosphericEffect("HEAT", SpaceSuitStat.HEAT_RESISTANCE, (player, level) -> {
        player.setFireTicks(Ints.constrainToRange((int)(240 * level), (int)0, (int)player.getMaxFireTicks()));
        if (level > 3) {
            player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
        }
    });
    public static final AtmosphericEffect COLD = new AtmosphericEffect("COLD", SpaceSuitStat.COLD_RESISTANCE, (player, level) -> {
        player.damage((double)(level * 2));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 200, Math.min(200, level), false, false, false));
        player.setFreezeTicks(Ints.constrainToRange((int)(150 * level), (int)0, (int)player.getMaxFreezeTicks()));
    });
    private final String id;
    @Nullable
    private final SpaceSuitStat stat;
    private final BiConsumer<Player, Integer> applier;

    public AtmosphericEffect(@NonNull String id, @Nullable SpaceSuitStat stat, @NonNull PotionEffectType effectType) {
        this(id, stat, (Player player, Integer level) -> player.addPotionEffect(new PotionEffect(effectType, 200, Math.min(200, level - 1), false, false, false)));
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (effectType == null) {
            throw new NullPointerException("effectType is marked non-null but is null");
        }
    }

    public AtmosphericEffect(@NonNull String id, @Nullable SpaceSuitStat stat, @NonNull BiConsumer<Player, Integer> applier) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (applier == null) {
            throw new NullPointerException("applier is marked non-null but is null");
        }
        this.id = id;
        this.stat = stat;
        this.applier = applier;
        allEffects.put(id, this);
    }

    public static AtmosphericEffect getById(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return allEffects.get(id);
    }

    public void apply(@NonNull Player p, int level) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (level > 0) {
            p.sendMessage(ChatColor.RED + "You have been exposed to " + this + "!");
            this.applier.accept(p, level);
        }
    }

    public String toString() {
        return ChatUtils.humanize((String)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static Map<String, AtmosphericEffect> allEffects() {
        return allEffects;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public SpaceSuitStat stat() {
        return this.stat;
    }
}

