/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.universe.saturn;

import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.AlienWorld;
import io.github.addoncommunity.galactifun.api.worlds.populators.OrePopulator;
import io.github.addoncommunity.galactifun.base.BaseMats;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.noise.SimplexOctaveGenerator;

public final class Titan
extends AlienWorld {
    private static final Set<Biome> forests = EnumSet.of(Biome.FOREST, new Biome[]{Biome.BIRCH_FOREST, Biome.TALL_BIRCH_FOREST, Biome.WOODED_HILLS, Biome.BIRCH_FOREST_HILLS, Biome.FLOWER_FOREST, Biome.TALL_BIRCH_FOREST, Biome.WOODED_HILLS, Biome.WOODED_MOUNTAINS});
    private SimplexOctaveGenerator generator;

    public Titan(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    private static Biome removeRiver(ChunkGenerator.BiomeGrid grid, int x, int z, int height) {
        Biome biome = grid.getBiome(x, height, z);
        for (int dev = 1; dev < 16; ++dev) {
            if (x - dev >= 0 && grid.getBiome(x - dev, height, z) != Biome.RIVER && grid.getBiome(x - dev, height, z) != Biome.FROZEN_RIVER) {
                biome = grid.getBiome(x - dev, height, z);
                for (int y = 0; y < 256; ++y) {
                    grid.setBiome(x, y, z, biome);
                }
                return biome;
            }
            if (x + dev <= 16 && grid.getBiome(x + dev, height, z) != Biome.RIVER && grid.getBiome(x + dev, height, z) != Biome.FROZEN_RIVER) {
                biome = grid.getBiome(x + dev, height, z);
                for (int y = 0; y < 256; ++y) {
                    grid.setBiome(x, y, z, biome);
                }
                return biome;
            }
            if (z - dev >= 0 && grid.getBiome(x, height, z - dev) != Biome.RIVER && grid.getBiome(x, height, z - dev) != Biome.FROZEN_RIVER) {
                biome = grid.getBiome(x, height, z - dev);
                for (int y = 0; y < 256; ++y) {
                    grid.setBiome(x, y, z, biome);
                }
                return biome;
            }
            if (z + dev > 16 || grid.getBiome(x, height, z + dev) == Biome.RIVER || grid.getBiome(x, height, z + dev) == Biome.FROZEN_RIVER) continue;
            biome = grid.getBiome(x, height, z + dev);
            for (int y = 0; y < 256; ++y) {
                grid.setBiome(x, y, z, biome);
            }
            return biome;
        }
        return biome;
    }

    private static void generateRest(int height, ChunkGenerator.ChunkData chunk, Random random, int x, int z) {
        for (int y = height; y > 0; --y) {
            if (random.nextBoolean()) {
                chunk.setBlock(x, y, z, Material.STONE);
                continue;
            }
            chunk.setBlock(x, y, z, Material.COAL_ORE);
        }
    }

    @Override
    protected void generateChunk(@Nonnull ChunkGenerator.ChunkData chunk, @Nonnull ChunkGenerator.BiomeGrid grid, @Nonnull Random random, @Nonnull World world, int chunkX, int chunkZ) {
        if (this.generator == null) {
            this.generator = new SimplexOctaveGenerator(world, 8);
            this.generator.setScale(0.004);
        }
        int x = 0;
        int realX = chunkX << 4;
        while (x < 16) {
            int z = 0;
            int realZ = chunkZ << 4;
            while (z < 16) {
                chunk.setBlock(x, 0, z, Material.BEDROCK);
                double startHeight = this.generator.noise((double)realX, (double)realZ, 0.5, 0.5, true);
                int height = (int)(55.0 + 30.0 * (startHeight * startHeight));
                Biome biome = grid.getBiome(x, height, z);
                if (biome == Biome.RIVER || biome == Biome.FROZEN_RIVER) {
                    biome = Titan.removeRiver(grid, x, z, height);
                }
                switch (biome) {
                    case BADLANDS: 
                    case MODIFIED_BADLANDS_PLATEAU: 
                    case MODIFIED_WOODED_BADLANDS_PLATEAU: 
                    case ERODED_BADLANDS: 
                    case DESERT: {
                        int y;
                        if (random.nextDouble() < 0.1) {
                            for (y = height + random.nextInt(4); y > height; --y) {
                                chunk.setBlock(x, y, z, Material.COAL_BLOCK);
                            }
                        }
                        chunk.setBlock(x, height + 1, z, Material.COAL_BLOCK);
                        Titan.generateRest(height, chunk, random, x, z);
                        break;
                    }
                    case WOODED_BADLANDS_PLATEAU: 
                    case BADLANDS_PLATEAU: 
                    case DESERT_HILLS: 
                    case DESERT_LAKES: {
                        int y;
                        if (random.nextDouble() < 0.1) {
                            for (y = height + random.nextInt(4); y > height; --y) {
                                if (random.nextBoolean()) {
                                    chunk.setBlock(x, y, z, Material.COAL_BLOCK);
                                    continue;
                                }
                                chunk.setBlock(x, y, z, Material.PACKED_ICE);
                            }
                        }
                        chunk.setBlock(x, height + 1, z, Material.COAL_BLOCK);
                        Titan.generateRest(height, chunk, random, x, z);
                        break;
                    }
                    case BIRCH_FOREST: 
                    case WOODED_HILLS: 
                    case WOODED_MOUNTAINS: 
                    case FLOWER_FOREST: 
                    case BIRCH_FOREST_HILLS: 
                    case TALL_BIRCH_FOREST: 
                    case TALL_BIRCH_HILLS: 
                    case FOREST: {
                        if (random.nextBoolean()) {
                            chunk.setBlock(x, height + 1, z, Material.WARPED_NYLIUM);
                        } else {
                            chunk.setBlock(x, height + 1, z, Material.CRIMSON_NYLIUM);
                        }
                        Titan.generateRest(height, chunk, random, x, z);
                        break;
                    }
                    case SNOWY_TAIGA: 
                    case SNOWY_TAIGA_HILLS: 
                    case SNOWY_TAIGA_MOUNTAINS: {
                        chunk.setBlock(x, height + 1, z, Material.WARPED_NYLIUM);
                        Titan.generateRest(height, chunk, random, x, z);
                        break;
                    }
                    case COLD_OCEAN: 
                    case DEEP_LUKEWARM_OCEAN: 
                    case DEEP_OCEAN: 
                    case DEEP_WARM_OCEAN: 
                    case LUKEWARM_OCEAN: 
                    case DEEP_COLD_OCEAN: 
                    case FROZEN_OCEAN: 
                    case DEEP_FROZEN_OCEAN: 
                    case WARM_OCEAN: 
                    case OCEAN: 
                    case BEACH: 
                    case SNOWY_BEACH: {
                        if (height <= 58) {
                            for (int i = 58; i > height; --i) {
                                chunk.setBlock(x, i, z, Material.WATER);
                            }
                        }
                        chunk.setBlock(x, height + 1, z, Material.SAND);
                        Titan.generateRest(height, chunk, random, x, z);
                        break;
                    }
                    default: {
                        chunk.setBlock(x, height + 1, z, Material.BLUE_ICE);
                        Titan.generateRest(height, chunk, random, x, z);
                    }
                }
                ++z;
                ++realZ;
            }
            ++x;
            ++realX;
        }
    }

    @Override
    public void getPopulators(@Nonnull List<BlockPopulator> populators) {
        populators.add(new BlockPopulator(){

            public void populate(@Nonnull World world, @Nonnull Random random, @Nonnull Chunk chunk) {
                int amount = random.nextInt(2) + 1;
                for (int i = 0; i < amount; ++i) {
                    int x = random.nextInt(15);
                    int z = random.nextInt(15);
                    Block b = world.getHighestBlockAt((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z);
                    if (!forests.contains(b.getBiome())) continue;
                    if (b.getType() == Material.WARPED_NYLIUM) {
                        world.generateTree(b.getLocation().add(0.0, 1.0, 0.0), TreeType.WARPED_FUNGUS);
                        continue;
                    }
                    world.generateTree(b.getLocation().add(0.0, 1.0, 0.0), TreeType.CRIMSON_FUNGUS);
                }
            }
        });
        populators.add(new BlockPopulator(){

            public void populate(@Nonnull World world, @Nonnull Random random, @Nonnull Chunk chunk) {
                if (random.nextDouble() < 0.25) {
                    int x = random.nextInt(15);
                    int z = random.nextInt(15);
                    Block b = world.getHighestBlockAt((chunk.getX() << 4) + x, (chunk.getZ() << 4) + z);
                    if (b.getBiome() == Biome.SNOWY_TAIGA || b.getBiome() == Biome.SNOWY_TAIGA_HILLS || b.getBiome() == Biome.SNOWY_TAIGA_MOUNTAINS) {
                        world.generateTree(b.getLocation().add(0.0, 1.0, 0.0), TreeType.WARPED_FUNGUS);
                    }
                }
            }
        });
        populators.add(new OrePopulator(1, 50, 1, 40, 2, 6, BaseMats.LASERITE_ORE, Material.STONE, Material.COAL_ORE));
    }
}

