/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere;

import com.google.common.primitives.Ints;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitStat;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@ParametersAreNonnullByDefault
public final class AtmosphericEffect {
    public static final AtmosphericEffect RADIATION = new AtmosphericEffect("RADIATION", SpaceSuitStat.RADIATION_RESISTANCE, PotionEffectType.WITHER);
    public static final AtmosphericEffect HEAT = new AtmosphericEffect("HEAT", SpaceSuitStat.HEAT_RESISTANCE, (player, level) -> {
        player.setFireTicks(Ints.constrainToRange((int)(240 * level), (int)0, (int)player.getMaxFireTicks()));
        if (level > 3) {
            player.removePotionEffect(PotionEffectType.FIRE_RESISTANCE);
        }
    });
    public static final AtmosphericEffect COLD = new AtmosphericEffect("COLD", SpaceSuitStat.COLD_RESISTANCE, (player, level) -> {
        player.damage((double)(level * 2));
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 200, Math.min(200, level), false, false, false));
        player.setFreezeTicks(Ints.constrainToRange((int)(150 * level), (int)0, (int)player.getMaxFreezeTicks()));
    });
    private final String id;
    @Nullable
    private final SpaceSuitStat stat;
    private final BiConsumer<Player, Integer> applier;

    public AtmosphericEffect(@Nonnull String id, @Nullable SpaceSuitStat stat, @Nonnull PotionEffectType effectType) {
        this(id, stat, (Player player, Integer level) -> player.addPotionEffect(new PotionEffect(effectType, 200, Math.min(200, level - 1), false, false, false)));
    }

    public void apply(Player p, int level) {
        if (level > 0) {
            p.sendMessage(ChatColor.RED + "You have been exposed to " + this + "!");
            this.applier.accept(p, level);
        }
    }

    public String toString() {
        return ChatUtils.humanize((String)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public AtmosphericEffect(String id, @Nullable SpaceSuitStat stat, BiConsumer<Player, Integer> applier) {
        this.id = id;
        this.stat = stat;
        this.applier = applier;
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public SpaceSuitStat stat() {
        return this.stat;
    }
}

