/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items.knowledge;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.items.knowledge.KnowledgeLevel;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.infinitylib.common.Scheduler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import javax.annotation.Nonnull;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public final class PlanetaryAnalyzer
extends SimpleSlimefunItem<BlockUseHandler> {
    public PlanetaryAnalyzer(SlimefunItemStack item, ItemStack[] recipe) {
        super(CoreItemGroup.MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
    }

    @Nonnull
    public BlockUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            NamespacedKey key = Galactifun.createKey("analyzing_" + p.getUniqueId());
            PlanetaryWorld world = Galactifun.worldManager().getWorld(p.getWorld());
            if (world == null) {
                p.sendMessage(ChatColor.RED + "You must be on a planet to use this!");
                return;
            }
            if (PersistentDataAPI.getBoolean((PersistentDataHolder)world.worldStorage(), (NamespacedKey)key)) {
                p.sendMessage(ChatColor.RED + "Already analyzing!");
                return;
            }
            p.sendMessage(ChatColor.GREEN + "Analyzing planet " + world.name());
            PersistentDataAPI.setBoolean((PersistentDataHolder)world.worldStorage(), (NamespacedKey)key, (boolean)true);
            Scheduler.run(36000, () -> {
                PersistentDataAPI.setBoolean((PersistentDataHolder)world.worldStorage(), (NamespacedKey)key, (boolean)false);
                KnowledgeLevel.BASIC.set(p, world);
            });
        };
    }
}

