/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.core;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.UniversalObject;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.addoncommunity.galactifun.base.BaseUniverse;
import io.github.addoncommunity.galactifun.base.items.knowledge.KnowledgeLevel;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class WorldSelector {
    private static final int MAX_OBJECTS_PER_PAGE = 52;
    private final Map<UUID, UniversalObject> history = new HashMap<UUID, UniversalObject>();
    @Nonnull
    private final ChestMenu.MenuClickHandler exitHandler;
    @Nonnull
    private final ItemModifier modifier;
    @Nonnull
    private final SelectHandler selectHandler;

    public WorldSelector(@Nonnull ChestMenu.MenuClickHandler exitHandler, @Nonnull ItemModifier modifier, @Nonnull SelectHandler selectHandler) {
        this.exitHandler = exitHandler;
        this.selectHandler = selectHandler;
        this.modifier = modifier;
    }

    public WorldSelector(@Nonnull ChestMenu.MenuClickHandler exitHandler) {
        this(exitHandler, (p, world, lore) -> true, (p, world) -> {});
    }

    public WorldSelector(@Nonnull ItemModifier modifier, @Nonnull SelectHandler selectHandler) {
        this((p, i, s, a) -> false, modifier, selectHandler);
    }

    public WorldSelector(@Nonnull SelectHandler selectHandler) {
        this((p, world, lore) -> true, selectHandler);
    }

    public void open(@Nonnull Player p) {
        this.open(p, this.history.computeIfAbsent(p.getUniqueId(), k -> BaseUniverse.THE_UNIVERSE), false);
    }

    private void open(@Nonnull Player p, @Nonnull UniversalObject object, boolean history) {
        List<UniversalObject> orbiters = object.orbiters();
        if (orbiters.size() == 0) {
            this.open(p, BaseUniverse.THE_UNIVERSE, true);
            return;
        }
        if (history) {
            this.history.put(p.getUniqueId(), object);
        }
        ChestMenu menu = new ChestMenu(object.name());
        menu.setEmptySlotsClickable(false);
        menu.addItem(0, ChestMenuUtils.getBackButton((Player)p, (String[])new String[0]));
        if (object.orbiting() == null) {
            menu.addMenuClickHandler(0, this.exitHandler);
        } else {
            menu.addMenuClickHandler(0, (p1, slot, item, a) -> {
                this.open(p1, object.orbiting(), true);
                return false;
            });
        }
        PlanetaryWorld current = Galactifun.worldManager().getWorld(p.getWorld());
        boolean known = current != null;
        int offset = 1;
        UniversalObject universalObject = object;
        if (universalObject instanceof PlanetaryWorld) {
            PlanetaryWorld world = (PlanetaryWorld)universalObject;
            ItemStack item2 = world.item();
            ++offset;
            if (known) {
                double distance = world.distanceTo(current);
                ItemMeta meta = item2.getItemMeta();
                List lore = meta.lore();
                if (lore != null) {
                    lore.remove(lore.size() - 1);
                    if (distance > 0.0) {
                        lore.add(Component.text((String)("Distance: " + (distance < 1.0 ? distance * 9.461E12 + " Kilometers" : distance + " Light Years"))).color((TextColor)NamedTextColor.GRAY));
                    } else {
                        lore.add(Component.text((String)"You are here!").color((TextColor)NamedTextColor.GRAY));
                    }
                    KnowledgeLevel.get(p, world).addLore(lore, world);
                    if (this.modifier.modifyItem(p, world, lore)) {
                        meta.lore(lore);
                        item2 = item2.clone();
                        item2.setItemMeta(meta);
                    }
                }
            }
            menu.addItem(1, item2, (player, i, itemStack, clickAction) -> {
                this.selectHandler.onSelect(player, world);
                return false;
            });
        }
        for (int i2 = 0; i2 < Math.min(52, orbiters.size()); ++i2) {
            PlanetaryWorld planetaryWorld;
            UniversalObject orbiter = orbiters.get(i2);
            UniversalObject universalObject2 = orbiter;
            if (universalObject2 instanceof PlanetaryWorld && !(planetaryWorld = (PlanetaryWorld)universalObject2).enabled()) {
                --offset;
                continue;
            }
            ItemStack item3 = orbiter.item();
            if (known) {
                double distance = orbiter.distanceTo(current);
                ItemMeta meta = item3.getItemMeta();
                List lore = meta.lore();
                if (lore != null) {
                    lore.remove(lore.size() - 1);
                    if (distance > 0.0) {
                        lore.add(Component.text((String)("Distance: " + (distance < 1.0 ? distance * 9.461E12 + " Kilometers" : distance + " Light Years"))).color((TextColor)NamedTextColor.GRAY));
                    } else {
                        lore.add(Component.text((String)"You are here!").color((TextColor)NamedTextColor.GRAY));
                    }
                    UniversalObject universalObject3 = orbiter;
                    if (universalObject3 instanceof PlanetaryWorld) {
                        PlanetaryWorld planetaryWorld2 = (PlanetaryWorld)universalObject3;
                        KnowledgeLevel.get(p, planetaryWorld2).addLore(lore, planetaryWorld2);
                    }
                    if (!this.modifier.modifyItem(p, orbiter, lore)) continue;
                    meta.lore(lore);
                    item3 = item3.clone();
                    item3.setItemMeta(meta);
                }
            }
            menu.addItem(i2 + offset, item3);
            if (orbiter.orbiters().size() == 0) {
                menu.addMenuClickHandler(i2 + offset, (clicker, i1, s, a) -> {
                    UniversalObject planetaryWorld$temp = orbiter;
                    if (planetaryWorld$temp instanceof PlanetaryWorld) {
                        PlanetaryWorld planetaryWorld = (PlanetaryWorld)planetaryWorld$temp;
                        this.selectHandler.onSelect(clicker, planetaryWorld);
                    }
                    return false;
                });
                continue;
            }
            menu.addMenuClickHandler(i2 + offset, (p1, slot, item1, a) -> {
                this.open(p1, orbiter, true);
                return false;
            });
        }
        menu.open(new Player[]{p});
    }

    @FunctionalInterface
    public static interface SelectHandler {
        public void onSelect(@Nonnull Player var1, @Nonnull PlanetaryWorld var2);
    }

    @FunctionalInterface
    public static interface ItemModifier {
        public boolean modifyItem(@Nonnull Player var1, @Nonnull UniversalObject var2, @Nonnull List<Component> var3);
    }
}

