/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes;

import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.GameRule;
import org.bukkit.World;

public final class DayCycle {
    public static final DayCycle ETERNAL_DAY = DayCycle.eternal(6000L);
    public static final DayCycle ETERNAL_NIGHT = DayCycle.eternal(18000L);
    public static final DayCycle EARTH_LIKE = DayCycle.hours(24);
    @Nonnull
    private final String description;
    private final long startTime;
    private final long perFiveSeconds;

    @Nonnull
    public static DayCycle eternal(long time) {
        return new DayCycle(time);
    }

    @Nonnull
    public static DayCycle relativeToEarth(double ratio) {
        return DayCycle.hours((int)(24.0 * ratio));
    }

    @Nonnull
    public static DayCycle days(int days) {
        return new DayCycle(days, 0);
    }

    @Nonnull
    public static DayCycle hours(int hours) {
        return new DayCycle(hours / 24, hours % 24);
    }

    @Nonnull
    public static DayCycle of(int days, int hours) {
        return new DayCycle(days + hours / 24, hours % 24);
    }

    private DayCycle(int days, int hours) {
        Validate.isTrue((days > 0 && hours >= 0 || hours > 0 && days >= 0 ? 1 : 0) != 0, (String)"Day cycles must last at least 1 hour!");
        StringBuilder builder = new StringBuilder();
        if (days > 0) {
            builder.append(days);
            builder.append(" day");
            if (days != 1) {
                builder.append('s');
            }
            builder.append(' ');
        }
        if (hours > 0) {
            builder.append(hours);
            builder.append(" hour");
            if (hours != 1) {
                builder.append('s');
            }
        }
        this.description = builder.toString();
        this.startTime = -1L;
        this.perFiveSeconds = (long)days * 100L + (long)hours * 4L;
    }

    private DayCycle(long time) {
        Validate.isTrue((time >= 0L && time < 24000L ? 1 : 0) != 0, (String)"Eternal time must be between 0 and 24000!");
        this.description = "Eternal " + (time < 12000L ? "Day" : "Night");
        this.startTime = time;
        this.perFiveSeconds = 0L;
    }

    public void applyEffects(@Nonnull World world) {
        world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        if (this.startTime != -1L) {
            world.setTime(this.startTime);
        }
    }

    public void tick(@Nonnull World world) {
        if (this.perFiveSeconds != 0L) {
            world.setTime(world.getTime() + this.perFiveSeconds);
        }
    }

    @Nonnull
    public String description() {
        return this.description;
    }
}

