/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.infinitylib.common;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

@ParametersAreNonnullByDefault
public final class StackUtils {
    private static final NamespacedKey ID_KEY = Slimefun.getItemDataService().getKey();

    @Nullable
    public static String getId(ItemStack item) {
        if (item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId();
        }
        if (item.hasItemMeta()) {
            return StackUtils.getId(item.getItemMeta());
        }
        return null;
    }

    @Nullable
    public static String getId(ItemMeta meta) {
        return (String)meta.getPersistentDataContainer().get(ID_KEY, PersistentDataType.STRING);
    }

    @Nonnull
    public static String getIdOrType(ItemStack item) {
        if (item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId();
        }
        if (item.hasItemMeta()) {
            String id = StackUtils.getId(item.getItemMeta());
            return id == null ? item.getType().name() : id;
        }
        return item.getType().name();
    }

    @Nullable
    public static ItemStack itemById(String id) {
        SlimefunItem item = SlimefunItem.getById((String)id);
        return item == null ? null : item.getItem().clone();
    }

    @Nonnull
    public static ItemStack itemByIdOrType(String idOrType) {
        SlimefunItem item = SlimefunItem.getById((String)idOrType);
        return item == null ? new ItemStack(Material.valueOf((String)idOrType)) : item.getItem().clone();
    }

    public static boolean isSimilar(@Nullable ItemStack first, @Nullable ItemStack second) {
        if (first == null || first.getType().isAir()) {
            return second == null || second.getType().isAir();
        }
        if (second == null || second.getType().isAir()) {
            return false;
        }
        if (first.hasItemMeta()) {
            if (second.hasItemMeta()) {
                ItemMeta firstMeta = first.getItemMeta();
                ItemMeta secondMeta = second.getItemMeta();
                String firstId = StackUtils.getId(firstMeta);
                if (firstId == null) {
                    if (StackUtils.getId(secondMeta) == null) {
                        if (first.getType() == second.getType()) {
                            if (firstMeta.hasDisplayName()) {
                                return secondMeta.hasDisplayName() && firstMeta.getDisplayName().equals(secondMeta.getDisplayName());
                            }
                            return !secondMeta.hasDisplayName();
                        }
                        return false;
                    }
                    return false;
                }
                return firstId.equals(StackUtils.getId(secondMeta));
            }
            return false;
        }
        if (second.hasItemMeta()) {
            return false;
        }
        return first.getType() == second.getType();
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

