/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items.protection;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Gas;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.infinitylib.machines.MenuBlock;
import io.github.addoncommunity.galactifun.util.BSUtils;
import io.github.addoncommunity.galactifun.util.Util;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public final class OxygenSealer
extends MenuBlock
implements EnergyNetComponent,
HologramOwner {
    private static final String PROTECTING = "oxygenating";
    private static final String NO_OXYGEN = "no_oxygen";
    private static final Set<BlockPosition> allBlocks = new HashSet<BlockPosition>();
    private static final int OXYGEN_SLOT = 4;
    private static int counter = 0;
    private final int range;

    public OxygenSealer(SlimefunItemStack item, ItemStack[] recipe, int range) {
        super(CoreItemGroup.MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.range = range;
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                allBlocks.add(new BlockPosition(b));
                int req = 64;
                if (OxygenSealer.this.getCharge(b.getLocation()) < req) {
                    BlockStorage.addBlockInfo((Block)b, (String)OxygenSealer.PROTECTING, (String)"false");
                } else {
                    BlockStorage.addBlockInfo((Block)b, (String)OxygenSealer.PROTECTING, (String)"true");
                    OxygenSealer.this.removeCharge(b.getLocation(), req);
                }
            }

            public void uniqueTick() {
                allBlocks.removeIf(pos -> !(BlockStorage.check((Location)pos.toLocation()) instanceof OxygenSealer));
                if (counter < 6) {
                    ++counter;
                } else {
                    counter = 0;
                    OxygenSealer.this.uniqueTick();
                }
            }
        }});
    }

    private void uniqueTick() {
        Galactifun.protectionManager().clearOxygenBlocks();
        for (BlockPosition l : allBlocks) {
            this.updateProtections(l);
        }
    }

    @Override
    protected void onPlace(@Nonnull BlockPlaceEvent e, @Nonnull Block b) {
        this.updateProtections(new BlockPosition(b));
    }

    @Override
    protected void onBreak(@Nonnull BlockBreakEvent e, @Nonnull BlockMenu menu) {
        this.removeHologram(e.getBlock());
        allBlocks.remove(new BlockPosition(e.getBlock()));
        this.uniqueTick();
    }

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            preset.addItem(i, MenuBlock.BACKGROUND_ITEM, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{4};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }

    @Nonnull
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public int getCapacity() {
        return 256;
    }

    private void updateProtections(BlockPosition pos) {
        Location l = pos.toLocation();
        Block b = pos.getBlock();
        if (!BSUtils.getStoredBoolean(l, PROTECTING)) {
            this.updateHologram(b, "&cNot Enough Energy");
            return;
        }
        BlockMenu menu = BlockStorage.getInventory((Block)b);
        if (!SlimefunUtils.isItemSimilar((ItemStack)menu.getItemInSlot(4), (ItemStack)Gas.OXYGEN.item(), (boolean)false, (boolean)false)) {
            this.updateHologram(b, "&cNo Oxygen");
            BSUtils.addBlockInfo(b, NO_OXYGEN, true);
            return;
        }
        if (Galactifun.slimefunTickCount() % 18 == 0 || BSUtils.getStoredBoolean(l, NO_OXYGEN)) {
            menu.consumeItem(4);
            BSUtils.addBlockInfo(b, NO_OXYGEN, false);
        }
        int range = this.range;
        for (BlockFace face : Util.SURROUNDING_FACES) {
            if (!BlockStorage.check((Block)b.getRelative(face), (String)BaseItems.SUPER_FAN.getItemId())) continue;
            range = (int)((double)range + (double)range * 0.15);
        }
        Optional<Set<BlockPosition>> returned = Util.floodFill(l, range);
        if (returned.isEmpty()) {
            this.updateHologram(b, "&cArea Not Sealed or Too Big");
            return;
        }
        for (BlockPosition bp : returned.get()) {
            Galactifun.protectionManager().addOxygenBlock(bp);
        }
        this.updateHologram(b, "&aOperational");
    }
}

