/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds.populators;

import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.BlockPopulator;

public class VolcanoPopulator
extends BlockPopulator {
    private final int minY;
    private final Material belowLiquid;
    private final Material liquid;

    public void populate(@Nonnull World world, @Nonnull Random random, @Nonnull Chunk chunk) {
        int startX = chunk.getX() << 4;
        int startZ = chunk.getZ() << 4;
        Block highestBlock = chunk.getBlock(0, 0, 0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Block b = world.getHighestBlockAt(startX + x, startZ + z);
                if (b.getY() <= highestBlock.getY()) continue;
                highestBlock = b;
            }
        }
        if (highestBlock.getY() >= this.minY) {
            highestBlock.getRelative(BlockFace.UP).setType(this.liquid);
            for (int i = 0; i < 7; ++i) {
                highestBlock.setType(this.belowLiquid, false);
                highestBlock = highestBlock.getRelative(BlockFace.DOWN);
            }
        }
    }

    public VolcanoPopulator(int minY, Material belowLiquid, Material liquid) {
        this.minY = minY;
        this.belowLiquid = belowLiquid;
        this.liquid = liquid;
    }
}

