/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere;

import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Gas;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.World;

@Nonnull
public final class AtmosphereBuilder {
    private final Map<AtmosphericEffect, Integer> effects = new HashMap<AtmosphericEffect, Integer>();
    private final Map<Gas, Double> composition = new EnumMap<Gas, Double>(Gas.class);
    private boolean weatherCycle;
    private boolean storming;
    private boolean thundering;
    private World.Environment environment = World.Environment.NORMAL;
    private double pressure = 1.0;

    public AtmosphereBuilder setNether() {
        this.environment = World.Environment.NETHER;
        return this;
    }

    public AtmosphereBuilder setEnd() {
        this.environment = World.Environment.THE_END;
        return this;
    }

    public AtmosphereBuilder addEffect(@Nonnull AtmosphericEffect effect, int level) {
        if (level > 0) {
            this.effects.put(effect, level);
        }
        return this;
    }

    public AtmosphereBuilder add(@Nonnull Gas gas, double percentage) {
        Validate.isTrue((percentage > 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        this.composition.put(gas, percentage);
        return this;
    }

    public AtmosphereBuilder enableWeather() {
        this.weatherCycle = true;
        return this;
    }

    public AtmosphereBuilder addStorm() {
        this.storming = true;
        return this;
    }

    public AtmosphereBuilder addThunder() {
        this.thundering = true;
        return this;
    }

    public AtmosphereBuilder setPressure(double pressureInAtm) {
        Validate.isTrue((pressureInAtm >= 0.0 ? 1 : 0) != 0, (String)"pressureInAtm is negative!");
        this.pressure = pressureInAtm;
        return this;
    }

    @Nonnull
    public Atmosphere build() {
        double percent = 0.0;
        for (Double decimal : this.composition.values()) {
            percent += decimal.doubleValue();
        }
        Validate.isTrue((percent < 101.0 ? 1 : 0) != 0, (String)"Percentage cannot be more than 100%!");
        if (percent != 0.0) {
            this.composition.put(Gas.OTHER, this.composition.getOrDefault((Object)Gas.OTHER, 0.0) + 100.0 - percent);
        }
        return new Atmosphere(this.weatherCycle, this.storming, this.thundering, this.environment, this.composition, this.pressure, this.effects);
    }
}

