/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.aliens.behaviors;

import com.destroystokyo.paper.entity.Pathfinder;
import com.destroystokyo.paper.entity.ai.GoalType;
import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.behaviors.AlienBehavior;
import io.github.addoncommunity.galactifun.infinitylib.common.Events;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.entity.Mob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public final class FleeGoal<T extends Mob>
extends AlienBehavior<T>
implements Listener {
    private final int fleeTicks;
    private int ticks = 0;

    public FleeGoal(@Nonnull Class<T> entityClass, @Nonnull T mob, int fleeTicks) {
        super(entityClass, Galactifun.createKey("flee"), (Mob)mob);
        this.fleeTicks = fleeTicks;
        Events.registerListener(this);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onHit(EntityDamageEvent e) {
        if (e.getEntity().getUniqueId().equals(this.mob.getUniqueId())) {
            this.ticks = this.fleeTicks;
        }
    }

    public boolean shouldActivate() {
        return this.ticks > 0;
    }

    public boolean shouldStayActive() {
        return this.ticks > 0;
    }

    public void stop() {
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        --this.ticks;
        Pathfinder pathfinder = this.mob.getPathfinder();
        if (!pathfinder.hasPath()) {
            Location mobLoc = this.mob.getLocation();
            Location l = null;
            for (int tries = 0; tries < 100; ++tries) {
                l = new Location(this.mob.getWorld(), (double)(mobLoc.getBlockX() + ThreadLocalRandom.current().nextInt(10) - 5), (double)mobLoc.getBlockY(), (double)(mobLoc.getBlockZ() + ThreadLocalRandom.current().nextInt(10) - 5));
                if (pathfinder.findPath(l) != null) continue;
                l.add(0.0, 1.0, 0.0);
                if (pathfinder.findPath(l) != null) break;
                l.subtract(0.0, 2.0, 0.0);
                if (pathfinder.findPath(l) != null) break;
            }
            if (pathfinder.findPath(l) != null) {
                pathfinder.moveTo(l, 3.0);
            }
        }
    }

    @Override
    @Nonnull
    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.JUMP);
    }
}

