/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds.populators;

import java.util.Random;
import javax.annotation.Nonnull;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.generator.BlockPopulator;

public class LakePopulator
extends BlockPopulator {
    private final int maxY;
    @Nonnull
    private final Material liquid;

    public void populate(@Nonnull World world, @Nonnull Random random, @Nonnull Chunk chunk) {
        int startX = chunk.getX() << 4;
        int startZ = chunk.getZ() << 4;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Block b = world.getHighestBlockAt(startX + x, startZ + z);
                if (b.getY() >= this.maxY) continue;
                for (int y = this.maxY; y > b.getY(); --y) {
                    chunk.getBlock(x, y, z).setType(this.liquid, false);
                }
            }
        }
    }

    public LakePopulator(int maxY, @Nonnull Material liquid) {
        if (liquid == null) {
            throw new NullPointerException("liquid is marked non-null but is null");
        }
        this.maxY = maxY;
        this.liquid = liquid;
    }
}

