/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.universe.attributes;

import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public final class Orbit {
    private static final long EARTH_YEAR = 35L;
    private final long year;
    private final double distance;

    @Nonnull
    public static Orbit kilometers(double kilometers, double year) {
        return new Orbit(kilometers / 9.7E9, year);
    }

    @Nonnull
    public static Orbit kilometers(double kilometers, long days) {
        return new Orbit(kilometers / 9.7E9, 365.0 / (double)days);
    }

    @Nonnull
    public static Orbit lightYears(double lightYears, double year) {
        return new Orbit(lightYears, year);
    }

    private Orbit(double distance, double year) {
        Validate.isTrue((distance >= 0.0 ? 1 : 0) != 0, (String)"Orbits must be positive!");
        this.distance = distance;
        this.year = (long)(35.0 * year) * 1200000L;
    }

    public double currentDistance() {
        return this.distance;
    }

    public double position() {
        if (this.year == 0L) {
            return 0.0;
        }
        return (double)(System.currentTimeMillis() % this.year) * Math.PI * 2.0 / (double)this.year;
    }
}

