/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.aliens;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.api.aliens.BossBarStyle;
import io.github.addoncommunity.galactifun.core.managers.AlienManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Location;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public abstract class BossAlien<T extends Mob>
extends Alien<T> {
    private static final int BOSS_BAR_DISTANCE_SQUARED = 400;
    private final Map<LivingEntity, BossBar> bossBars = new HashMap<LivingEntity, BossBar>();
    private final BossBarStyle style;
    private int tick = 0;

    @ParametersAreNonnullByDefault
    public BossAlien(Class<T> clazz, String id, String name, double maxHealth, int spawnChance, @Nonnull BossBarStyle style) {
        super(clazz, id, name, maxHealth, spawnChance);
        this.style = style;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onSpawn(@Nonnull T spawned) {
        BossBar bossbar = this.style.create(Galactifun.alienManager().bossKey(), this.name());
        bossbar.setVisible(true);
        bossbar.setProgress(1.0);
        spawned.setRemoveWhenFarAway(false);
        this.bossBars.put((LivingEntity)spawned, bossbar);
    }

    @Override
    public final void onHit(@Nonnull EntityDamageByEntityEvent e) {
        Entity entity;
        this.onBossHit(e);
        if (!e.isCancelled() && (entity = e.getEntity()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            BossBar bossbar = this.getBossBarForEntity(entity2);
            double finalHealth = entity2.getHealth() - e.getFinalDamage();
            if (finalHealth > 0.0) {
                bossbar.setProgress(finalHealth / this.maxHealth());
            }
        }
    }

    @Override
    public void onDamage(@Nonnull EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            BossBar bossbar = this.getBossBarForEntity(entity2);
            double finalHealth = entity2.getHealth() - e.getFinalDamage();
            if (finalHealth > 0.0) {
                bossbar.setProgress(finalHealth / this.maxHealth());
            }
        }
    }

    protected void onBossHit(@Nonnull EntityDamageByEntityEvent e) {
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onDeath(@Nonnull EntityDeathEvent e) {
        BossBar bossbar = this.getBossBarForEntity(e.getEntity());
        bossbar.removeAll();
        this.bossBars.remove(e.getEntity());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onUniqueTick() {
        ++this.tick;
        if (this.tick >= 10) {
            this.tick = 0;
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onTick(@Nonnull Mob mob) {
        if (this.tick == 0) {
            Location l = mob.getLocation();
            BossBar bossbar = this.getBossBarForEntity((LivingEntity)mob);
            List players = bossbar.getPlayers();
            for (Player player : mob.getWorld().getPlayers()) {
                double distSquared = l.distanceSquared(player.getLocation());
                if (distSquared <= 400.0) {
                    if (players.contains(player)) continue;
                    bossbar.addPlayer(player);
                    continue;
                }
                bossbar.removePlayer(player);
            }
            for (Player player : players) {
                if (player.getWorld().equals(mob.getWorld())) continue;
                bossbar.removePlayer(player);
            }
        }
    }

    @Nonnull
    protected final BossBar getBossBarForEntity(LivingEntity entity) {
        AlienManager manager = Galactifun.alienManager();
        BossBar bossbar = this.bossBars.get(entity);
        if (bossbar != null) {
            return bossbar;
        }
        bossbar = this.style.create(manager.bossKey(), this.name());
        bossbar.setVisible(true);
        bossbar.setProgress(entity.getHealth() / this.maxHealth());
        this.bossBars.put(entity, bossbar);
        return bossbar;
    }

    public void removeBossBars() {
        for (BossBar bossbar : this.bossBars.values()) {
            bossbar.setVisible(false);
            bossbar.removeAll();
        }
    }
}

