/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items;

import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuit;
import io.github.addoncommunity.galactifun.api.items.spacesuit.SpaceSuitUpgrade;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class SpaceSuitUpgrader
extends AContainer {
    public SpaceSuitUpgrader(ItemGroup category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Nullable
    protected MachineRecipe findNextRecipe(BlockMenu inv) {
        ItemStack suitStack = null;
        SpaceSuit suit = null;
        SpaceSuitUpgrade upgrade = null;
        ItemStack upgradeStack = null;
        for (int slot : this.getInputSlots()) {
            ItemMeta meta;
            ItemStack item = inv.getItemInSlot(slot);
            if (item == null || !item.hasItemMeta()) continue;
            SlimefunItem sfItem = SlimefunItem.getByItem((ItemStack)item);
            if (suit == null && sfItem instanceof SpaceSuit) {
                suit = (SpaceSuit)sfItem;
                suitStack = item;
            } else if (upgrade == null && sfItem instanceof SpaceSuitUpgrade) {
                upgrade = (SpaceSuitUpgrade)sfItem;
                upgradeStack = item;
            }
            if (suit == null || upgrade == null || !upgrade.addTo(meta = suitStack.getItemMeta(), suit.maxUpgrades())) continue;
            ItemStack newSuit = suitStack.clone();
            newSuit.setItemMeta(meta);
            upgradeStack.setAmount(upgradeStack.getAmount() - 1);
            suitStack.setAmount(0);
            return new MachineRecipe(5 / this.getSpeed(), new ItemStack[]{upgradeStack}, new ItemStack[]{newSuit});
        }
        return null;
    }

    public ItemStack getProgressBar() {
        return new ItemStack(Material.ANVIL);
    }

    @Nonnull
    public String getMachineIdentifier() {
        return "SPACE_SUIT_UPGRADER";
    }
}

