/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.items;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.AtmosphericEffect;
import io.github.addoncommunity.galactifun.base.BaseItems;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.infinitylib.machines.MenuBlock;
import io.github.addoncommunity.galactifun.util.BSUtils;
import io.github.addoncommunity.galactifun.util.Util;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class ProtectingBlock
extends MenuBlock
implements EnergyNetComponent,
HologramOwner {
    protected static final String PROTECTING = "protecting";
    protected static final String ENABLED = "enabled";
    private static final Set<BlockPosition> allBlocks = new HashSet<BlockPosition>();
    private static final ItemStack ENABLED_ITEM = new CustomItemStack(Material.STRUCTURE_VOID, "&aEnabled", new String[]{"", "&7Click to disable"});
    private static final ItemStack DISABLED_ITEM = new CustomItemStack(Material.BARRIER, "&cDisabled", new String[]{"", "&7Click to enable"});
    private static int counter = 0;

    @ParametersAreNonnullByDefault
    public ProtectingBlock(SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(CoreItemGroup.MACHINES, item, recipeType, recipe);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return false;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                allBlocks.add(new BlockPosition(b));
                BlockMenu menu = BlockStorage.getInventory((Block)b);
                int req = ProtectingBlock.this.getEnergyRequirement();
                if (ProtectingBlock.this.getCharge(b.getLocation()) < req) {
                    BlockStorage.addBlockInfo((Block)b, (String)ProtectingBlock.PROTECTING, (String)"false");
                } else {
                    BlockStorage.addBlockInfo((Block)b, (String)ProtectingBlock.PROTECTING, (String)"true");
                    ProtectingBlock.this.removeCharge(b.getLocation(), req);
                }
                ProtectingBlock.this.tick(b, menu);
            }

            public void uniqueTick() {
                allBlocks.removeIf(pos -> !(BlockStorage.check((Location)pos.toLocation()) instanceof ProtectingBlock));
                if (counter < 6) {
                    ++counter;
                } else {
                    counter = 0;
                    ProtectingBlock.this.uniqueTick();
                }
            }
        }});
    }

    private void uniqueTick() {
        Galactifun.protectionManager().clearProtectedBlocks();
        for (BlockPosition l : allBlocks) {
            this.updateProtections(l);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onPlace(@Nonnull BlockPlaceEvent e, @Nonnull Block b) {
        BlockStorage.addBlockInfo((Block)b, (String)ENABLED, (String)"true");
        this.updateProtections(new BlockPosition(b));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onBreak(@Nonnull BlockBreakEvent e, @Nonnull BlockMenu menu) {
        this.removeHologram(e.getBlock());
        allBlocks.remove(new BlockPosition(e.getBlock()));
        this.uniqueTick();
    }

    @Override
    protected final void setup(@Nonnull BlockMenuPreset preset) {
        for (int i = 0; i < 9; ++i) {
            if (i == 4) continue;
            preset.addItem(i, MenuBlock.BACKGROUND_ITEM, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onNewInstance(@Nonnull BlockMenu menu, @Nonnull Block b) {
        if (BSUtils.getStoredBoolean(b.getLocation(), ENABLED)) {
            menu.replaceExistingItem(4, ENABLED_ITEM);
            menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                BlockStorage.addBlockInfo((Block)b, (String)ENABLED, (String)"false");
                this.onNewInstance(menu, b);
                return false;
            });
        } else {
            menu.replaceExistingItem(4, DISABLED_ITEM);
            menu.addMenuClickHandler(4, (p, slot, item, action) -> {
                BlockStorage.addBlockInfo((Block)b, (String)ENABLED, (String)"true");
                this.onNewInstance(menu, b);
                return false;
            });
        }
    }

    @Nonnull
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    protected abstract int getEnergyRequirement();

    @Nonnull
    protected abstract AtmosphericEffect getEffect();

    public abstract int getProtection();

    public abstract int getRange();

    protected void tick(@Nonnull Block b, @Nonnull BlockMenu menu) {
    }

    private void updateProtections(@Nonnull BlockPosition pos) {
        Location l = pos.toLocation();
        Block b = pos.getBlock();
        if (!BSUtils.getStoredBoolean(l, ENABLED)) {
            this.updateHologram(b, "&cNot Enabled");
            return;
        }
        if (!BSUtils.getStoredBoolean(l, PROTECTING)) {
            this.updateHologram(b, "&cNot Enough Energy");
            return;
        }
        ProtectingBlock inst = Objects.requireNonNull((ProtectingBlock)BlockStorage.check((Location)l));
        int range = this.getRange();
        for (BlockFace face : Util.SURROUNDING_FACES) {
            if (!BlockStorage.check((Block)b.getRelative(face), (String)BaseItems.SUPER_FAN.getItemId())) continue;
            range = (int)((double)range + (double)range * 0.15);
        }
        Optional<Set<BlockPosition>> returned = Util.floodFill(l, range);
        if (returned.isEmpty()) {
            this.updateHologram(pos.getBlock(), "&cArea Not Sealed or Too Big");
            return;
        }
        for (BlockPosition bp : returned.get()) {
            Galactifun.protectionManager().addProtection(bp, inst.getEffect(), inst.getProtection());
        }
        this.updateHologram(b, "&aOperational");
    }

    @Override
    protected int[] getInputSlots() {
        return new int[0];
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[0];
    }
}

