/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;

public final class PersistentBlockPositions
implements PersistentDataType<String, Set<BlockPosition>> {
    public static final PersistentBlockPositions INSTANCE = new PersistentBlockPositions();

    private PersistentBlockPositions() {
    }

    @Nonnull
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    @Nonnull
    public Class<Set<BlockPosition>> getComplexType() {
        return Set.class;
    }

    @Nonnull
    public String toPrimitive(@Nonnull Set<BlockPosition> complex, @Nonnull PersistentDataAdapterContext context) {
        if (complex.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (BlockPosition pos : complex) {
            builder.append(pos.getWorld().getUID());
            builder.append(',');
            builder.append(pos.getPosition());
            builder.append(';');
        }
        return builder.deleteCharAt(builder.length() - 1).toString();
    }

    @Nonnull
    public Set<BlockPosition> fromPrimitive(@Nonnull String primitive, @Nonnull PersistentDataAdapterContext context) {
        HashSet<BlockPosition> positions = new HashSet<BlockPosition>();
        if (!primitive.isEmpty()) {
            for (String s : CommonPatterns.SEMICOLON.split(primitive)) {
                String[] split = CommonPatterns.COMMA.split(s);
                positions.add(new BlockPosition(Bukkit.getWorld((UUID)UUID.fromString(split[0])), Long.parseLong(split[1])));
            }
        }
        return positions;
    }
}

