/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class Util {
    public static final double KM_PER_LY = 9.7E9;
    public static final Pattern COORD_PATTERN = Pattern.compile("^-?\\d+ -?\\d+$");
    public static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    public static final BlockFace[] SURROUNDING_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    public static final Set<Material> IMPERMEABLE_BLOCKS = EnumSet.noneOf(Material.class);
    private static final BlockFace[] ALL_SIDES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    @Nonnull
    public static String timeSince(double nanoTime) {
        nanoTime = (double)System.nanoTime() - nanoTime;
        if (nanoTime >= 1.0E9) {
            return (int)(nanoTime / 1000000.0) / 1000 + " s";
        }
        return (double)((int)(nanoTime / 1000.0)) / 1000.0 + " ms";
    }

    @Nonnull
    public static Optional<Set<BlockPosition>> floodFill(@Nonnull Location start, int max) {
        if (max == 0) {
            return Optional.empty();
        }
        HashSet<Block> visited = new HashSet<Block>();
        ArrayDeque<Block> queue = new ArrayDeque<Block>();
        queue.add(start.getBlock());
        while (!queue.isEmpty()) {
            if (visited.size() > max) {
                return Optional.empty();
            }
            Block next = (Block)queue.remove();
            visited.add(next);
            for (BlockFace face : ALL_SIDES) {
                Block b = next.getRelative(face);
                if (IMPERMEABLE_BLOCKS.contains(b.getType()) || visited.contains(b) || queue.contains(b)) continue;
                queue.add(b);
            }
        }
        return Optional.of(visited.parallelStream().map(BlockPosition::new).collect(Collectors.toSet()));
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.GLASS_BLOCKS.getValues());
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.TERRACOTTA.getValues());
        IMPERMEABLE_BLOCKS.addAll(SlimefunTag.UNBREAKABLE_MATERIALS.getValues());
        IMPERMEABLE_BLOCKS.addAll(Arrays.asList(Material.IRON_DOOR, Material.IRON_TRAPDOOR, Material.OBSIDIAN, Material.IRON_BLOCK, Material.GOLD_BLOCK, Material.DIAMOND_BLOCK, Material.NETHERITE_BLOCK, Material.SEA_LANTERN, Material.QUARTZ_BLOCK, Material.SMOOTH_QUARTZ));
        for (Material material : Material.values()) {
            if (!material.name().startsWith("WAXED") && !material.name().endsWith("CONCRETE")) continue;
            IMPERMEABLE_BLOCKS.add(material);
        }
    }
}

