/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.api.worlds;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.api.aliens.Alien;
import io.github.addoncommunity.galactifun.api.universe.PlanetaryObject;
import io.github.addoncommunity.galactifun.api.universe.StarSystem;
import io.github.addoncommunity.galactifun.api.universe.attributes.DayCycle;
import io.github.addoncommunity.galactifun.api.universe.attributes.Gravity;
import io.github.addoncommunity.galactifun.api.universe.attributes.Orbit;
import io.github.addoncommunity.galactifun.api.universe.attributes.atmosphere.Atmosphere;
import io.github.addoncommunity.galactifun.api.universe.types.PlanetaryType;
import io.github.addoncommunity.galactifun.api.worlds.PlanetaryWorld;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public abstract class AlienWorld
extends PlanetaryWorld {
    public static final NamespacedKey CHUNK_VER_KEY = Galactifun.createKey("chunk_version");
    private final Map<Material, SlimefunItemStack> blockMappings = new EnumMap<Material, SlimefunItemStack>(Material.class);
    private final List<Alien<?>> species = new ArrayList();

    public AlienWorld(String name, PlanetaryType type, Orbit orbit, StarSystem orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    public AlienWorld(String name, PlanetaryType type, Orbit orbit, PlanetaryObject orbiting, ItemStack baseItem, DayCycle dayCycle, Atmosphere atmosphere, Gravity gravity) {
        super(name, type, orbit, orbiting, baseItem, dayCycle, atmosphere, gravity);
    }

    @Override
    @Nullable
    protected World loadWorld() {
        if (!this.getSetting("enabled", Boolean.class, this.enabledByDefault()).booleanValue()) {
            return null;
        }
        Galactifun.instance();
        Galactifun.log(Level.INFO, "Loading planet " + this.name());
        String worldName = "world_galactifun_" + this.id;
        World world = new WorldCreator(worldName).generator(new ChunkGenerator(){

            @Nonnull
            public ChunkGenerator.ChunkData generateChunkData(@Nonnull World world, @Nonnull Random random, int chunkX, int chunkZ, @Nonnull ChunkGenerator.BiomeGrid grid) {
                ChunkGenerator.ChunkData chunk = this.createChunkData(world);
                AlienWorld.this.generateChunk(chunk, grid, random, world, chunkX, chunkZ);
                return chunk;
            }

            @Nonnull
            public List<BlockPopulator> getDefaultPopulators(@Nonnull World world) {
                ArrayList<BlockPopulator> list = new ArrayList<BlockPopulator>(1);
                AlienWorld.this.getPopulators(list);
                list.add(new BlockPopulator(){

                    public void populate(@Nonnull World world, @Nonnull Random random, @Nonnull Chunk source) {
                        PersistentDataAPI.setString((PersistentDataHolder)source, (NamespacedKey)CHUNK_VER_KEY, (String)String.format("%s v%s", AlienWorld.this.addon().getName(), AlienWorld.this.addon().getPluginVersion()));
                    }
                });
                return list;
            }

            public Location getFixedSpawnLocation(@Nonnull World world, @Nonnull Random random) {
                Block b = world.getHighestBlockAt(random.nextInt(), random.nextInt());
                return b.getLocation();
            }
        }).environment(this.atmosphere().environment()).createWorld();
        Validate.notNull((Object)world, (String)("There was an error loading the world for " + worldName));
        if (world.getEnvironment() == World.Environment.THE_END) {
            world.getBlockAt(0, 0, 0).setType(Material.END_PORTAL);
            world.getBlockAt(0, 1, 0).setType(Material.BEDROCK);
            world.getBlockAt(1, 0, 0).setType(Material.BEDROCK);
            world.getBlockAt(-1, 0, 0).setType(Material.BEDROCK);
            world.getBlockAt(0, 0, 1).setType(Material.BEDROCK);
            world.getBlockAt(0, 0, -1).setType(Material.BEDROCK);
        }
        this.dayCycle().applyEffects(world);
        this.atmosphere().applyEffects(world);
        return world;
    }

    public final void addSpecies(Alien<?> ... aliens) {
        for (Alien<?> alien : aliens) {
            if (!alien.isRegistered()) {
                throw new IllegalStateException("You must register an alien before adding it to a world!");
            }
            this.species.add(alien);
        }
    }

    protected final <T> T getSetting(@Nonnull String path, @Nonnull Class<T> clazz, T defaultValue) {
        return Galactifun.worldManager().getSetting(this, path, clazz, defaultValue);
    }

    public final void addBlockMapping(@Nonnull Material vanillaItem, @Nonnull SlimefunItemStack slimefunItem) {
        this.blockMappings.put(vanillaItem, slimefunItem);
    }

    @Nullable
    public SlimefunItemStack getMappedItem(Block b) {
        return this.blockMappings.get(b.getType());
    }

    public boolean canSpawnVanillaMobs() {
        return false;
    }

    protected boolean enabledByDefault() {
        return true;
    }

    protected abstract void generateChunk(@Nonnull ChunkGenerator.ChunkData var1, @Nonnull ChunkGenerator.BiomeGrid var2, @Nonnull Random var3, @Nonnull World var4, int var5, int var6);

    protected abstract void getPopulators(@Nonnull List<BlockPopulator> var1);

    public final void applyEffects(@Nonnull Player p) {
        this.atmosphere().applyEffects(p);
    }

    public final void tickWorld() {
        block2: {
            World world = this.world();
            this.dayCycle().tick(world);
            for (Player p : world.getPlayers()) {
                this.gravity().applyGravity(p);
                if (p.getGameMode() != GameMode.SURVIVAL) continue;
                this.applyEffects(p);
            }
            this.dayCycle().tick(world);
            if (this.species.isEmpty() || world.getPlayers().isEmpty()) break block2;
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            Collections.shuffle(this.species, rand);
            int players = world.getPlayers().size();
            int mobs = world.getLivingEntities().size() - players;
            int max = players * Galactifun.worldManager().maxAliensPerPlayer();
            for (Alien<?> alien : this.species) {
                if ((mobs += alien.attemptSpawn(rand, world)) > max) break;
            }
        }
    }
}

