/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.base.items;

import io.github.addoncommunity.galactifun.Galactifun;
import io.github.addoncommunity.galactifun.core.CoreItemGroup;
import io.github.addoncommunity.galactifun.infinitylib.machines.MenuBlock;
import io.github.addoncommunity.galactifun.util.BSUtils;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public final class AutomaticDoor
extends MenuBlock {
    private static final int[] BACKGROUND = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
    private static final int INPUT_SLOT = 4;
    private static final String ACTIVE = "active";

    public AutomaticDoor(SlimefunItemStack item, ItemStack[] recipe) {
        super(CoreItemGroup.MACHINES, item, RecipeType.ENHANCED_CRAFTING_TABLE, recipe);
        this.addItemHandler(new ItemHandler[]{new BlockTicker(){

            public boolean isSynchronized() {
                return true;
            }

            public void tick(Block b, SlimefunItem item, Config data) {
                AutomaticDoor.this.tick(BlockStorage.getInventory((Block)b), b);
            }
        }});
    }

    @Override
    protected void onPlace(@Nonnull BlockPlaceEvent e, @Nonnull Block b) {
        BlockStorage.addBlockInfo((Block)b, (String)"player", (String)e.getPlayer().getUniqueId().toString());
    }

    private void tick(@Nonnull BlockMenu menu, @Nonnull Block b) {
        ItemStack stack;
        Location l = b.getLocation();
        Collection players = b.getWorld().getNearbyEntitiesByType(Player.class, l, (double)Galactifun.instance().getConfig().getInt("other.auto-door-range", 2));
        if (BSUtils.getStoredBoolean(l, ACTIVE)) {
            if (!players.isEmpty()) {
                BlockFace direction = ((Directional)b.getBlockData()).getFacing();
                Block startBlock = l.clone().add(direction.getDirection()).getBlock();
                if (startBlock.isEmpty()) {
                    BlockStorage.addBlockInfo((Location)l, (String)ACTIVE, (String)"false");
                    return;
                }
                ItemStack item = menu.getItemInSlot(4);
                Material mat = startBlock.getType();
                String id = BlockStorage.checkID((Block)startBlock);
                if (item == null || item.getType().isAir() || item.getType() == mat) {
                    OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo((Location)l, (String)"player")));
                    if (!Slimefun.getProtectionManager().hasPermission(p, l, Interaction.BREAK_BLOCK)) {
                        return;
                    }
                    int size = item == null || item.getType().isAir() ? mat.getMaxStackSize() : item.getMaxStackSize() - item.getAmount();
                    ItemStack itemStack = id == null ? new ItemStack(mat) : SlimefunItem.getById((String)id).getItem();
                    for (int i = 0; i < size && !startBlock.isEmpty() && startBlock.getType() == mat && Objects.equals(BlockStorage.checkID((Block)startBlock), id); ++i) {
                        startBlock.setType(Material.AIR);
                        menu.pushItem(itemStack.clone(), new int[]{4});
                        startBlock = startBlock.getRelative(direction);
                    }
                    BlockStorage.addBlockInfo((Location)l, (String)ACTIVE, (String)"false");
                }
            }
        } else if (players.isEmpty() && (stack = menu.getItemInSlot(4)) != null && stack.getType().isBlock()) {
            Block next;
            OfflinePlayer p = Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo((Location)l, (String)"player")));
            if (!Slimefun.getProtectionManager().hasPermission(p, l, Interaction.PLACE_BLOCK)) {
                return;
            }
            Location start = l.clone();
            Vector v = ((Directional)b.getBlockData()).getFacing().getDirection();
            int amount = stack.getAmount();
            SlimefunItem item = SlimefunItem.getByItem((ItemStack)stack);
            for (int i = 0; i < amount && (next = start.add(v).getBlock()).isEmpty(); ++i) {
                next.setType(stack.getType());
                if (item != null) {
                    BlockStorage.addBlockInfo((Block)next, (String)"id", (String)item.getId());
                }
                menu.consumeItem(4);
            }
            BlockStorage.addBlockInfo((Location)l, (String)ACTIVE, (String)"true");
        }
    }

    @Override
    protected void setup(@Nonnull BlockMenuPreset preset) {
        preset.drawBackground(BACKGROUND);
    }

    @Override
    protected int[] getInputSlots() {
        return new int[]{4};
    }

    @Override
    protected int[] getOutputSlots() {
        return new int[]{4};
    }
}

