/*
 * Decompiled with CFR 0.152.
 */
package io.github.addoncommunity.galactifun.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;

public final class BSUtils {
    @ParametersAreNonnullByDefault
    public static <T> void addBlockInfo(Block b, String key, T o) {
        BSUtils.addBlockInfo(b, key, o, String::valueOf);
    }

    @ParametersAreNonnullByDefault
    public static <T> void addBlockInfo(Block b, String key, T o, Function<T, String> map) {
        BlockStorage.addBlockInfo((Block)b, (String)key, (String)map.apply(o));
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public static <T> T getLocationInfo(Location l, String key, Function<String, T> map) {
        String s = BlockStorage.getLocationInfo((Location)l, (String)key);
        if (s == null) {
            return null;
        }
        return map.apply(s);
    }

    @ParametersAreNonnullByDefault
    public static int getStoredInt(Location l, String key) {
        String s = BlockStorage.getLocationInfo((Location)l, (String)key);
        if (s == null || s.isEmpty() || s.isBlank()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    @ParametersAreNonnullByDefault
    public static double getStoredDouble(Location l, String key) {
        String s = BlockStorage.getLocationInfo((Location)l, (String)key);
        if (s == null || s.isEmpty() || s.isBlank()) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    @ParametersAreNonnullByDefault
    public static boolean getStoredBoolean(Location l, String key) {
        return Boolean.parseBoolean(BlockStorage.getLocationInfo((Location)l, (String)key));
    }

    private BSUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

