/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.utils;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.FoxyMachines;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SimpleLocation {
    private int x;
    private int y;
    private int z;
    private final String worldUUID;
    private final String prefix;

    @Nonnull
    public Block toBlock() {
        return Bukkit.getServer().getWorld(UUID.fromString(this.worldUUID)).getBlockAt(this.x, this.y, this.z);
    }

    public SimpleLocation(@Nonnull Block b, @Nonnull String prefix) {
        this(b.getLocation(), prefix);
    }

    public SimpleLocation(@Nonnull Location loc, @Nonnull String prefix) {
        this.worldUUID = loc.getWorld().getUID().toString();
        this.x = loc.getBlockX();
        this.y = loc.getBlockY();
        this.z = loc.getBlockZ();
        this.prefix = prefix;
    }

    public void storePersistently(@Nonnull PersistentDataContainer container) {
        container.set(SimpleLocation.getXKey(this.prefix), PersistentDataType.INTEGER, (Object)this.x);
        container.set(SimpleLocation.getYKey(this.prefix), PersistentDataType.INTEGER, (Object)this.y);
        container.set(SimpleLocation.getZKey(this.prefix), PersistentDataType.INTEGER, (Object)this.z);
        container.set(SimpleLocation.getWorldKey(this.prefix), PersistentDataType.STRING, (Object)this.worldUUID);
    }

    @Nullable
    public static SimpleLocation fromPersistentStorage(@Nonnull PersistentDataContainer container, @Nonnull String prefix) {
        if (container.has(SimpleLocation.getWorldKey(prefix), PersistentDataType.STRING)) {
            return new SimpleLocation((Integer)container.get(SimpleLocation.getXKey(prefix), PersistentDataType.INTEGER), (Integer)container.get(SimpleLocation.getYKey(prefix), PersistentDataType.INTEGER), (Integer)container.get(SimpleLocation.getZKey(prefix), PersistentDataType.INTEGER), (String)container.get(SimpleLocation.getWorldKey(prefix), PersistentDataType.STRING), prefix);
        }
        return null;
    }

    private static NamespacedKey getWorldKey(@Nonnull String prefix) {
        return new NamespacedKey((Plugin)FoxyMachines.getInstance(), prefix + "_world");
    }

    private static NamespacedKey getXKey(@Nonnull String prefix) {
        return new NamespacedKey((Plugin)FoxyMachines.getInstance(), prefix + "_x");
    }

    private static NamespacedKey getYKey(@Nonnull String prefix) {
        return new NamespacedKey((Plugin)FoxyMachines.getInstance(), prefix + "_y");
    }

    private static NamespacedKey getZKey(@Nonnull String prefix) {
        return new NamespacedKey((Plugin)FoxyMachines.getInstance(), prefix + "_z");
    }

    public String toString() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z;
    }

    public SimpleLocation(int x, int y, int z, String worldUUID, String prefix) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldUUID = worldUUID;
        this.prefix = prefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleLocation)) {
            return false;
        }
        SimpleLocation other = (SimpleLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getZ() != other.getZ()) {
            return false;
        }
        String this$worldUUID = this.getWorldUUID();
        String other$worldUUID = other.getWorldUUID();
        if (this$worldUUID == null ? other$worldUUID != null : !this$worldUUID.equals(other$worldUUID)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleLocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        String $worldUUID = this.getWorldUUID();
        result = result * 59 + ($worldUUID == null ? 43 : $worldUUID.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getWorldUUID() {
        return this.worldUUID;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

