/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.listeners;

import java.util.Map;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public class SlimeWorldCompatListener
implements Listener {
    @EventHandler
    public void onWorldLoad(WorldLoadEvent e) {
        this.reapplyChunkLoaders(e.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent e) {
        this.clearChunkLoaders(e.getWorld());
    }

    private void reapplyChunkLoaders(World world) {
        Map storage = BlockStorage.getRawStorage((World)world);
        if (storage == null) {
            return;
        }
        for (Location loc : storage.keySet()) {
            try {
                String id = BlockStorage.checkID((Location)loc);
                if (id == null || !id.equals("CHUNK_LOADER")) continue;
                loc.getChunk().setForceLoaded(true);
            }
            catch (Exception exception) {}
        }
    }

    private void clearChunkLoaders(World world) {
        Map storage = BlockStorage.getRawStorage((World)world);
        if (storage == null) {
            return;
        }
        for (Location loc : storage.keySet()) {
            try {
                String id = BlockStorage.checkID((Location)loc);
                if (id == null || !id.equals("CHUNK_LOADER")) continue;
                loc.getChunk().setForceLoaded(false);
            }
            catch (Exception exception) {}
        }
    }
}

