/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.listeners;

import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.ChunkPosition;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import me.gallowsdove.foxymachines.implementation.materials.GhostBlock;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;

public class ChunkLoadListener
implements Listener {
    private static final Set<ChunkPosition> SCANNED_CHUNKS = new HashSet<ChunkPosition>();

    @EventHandler
    public void onChunkLoad(@Nonnull ChunkLoadEvent e) {
        Chunk chunk = e.getChunk();
        ChunkPosition chunkPosition = new ChunkPosition(chunk);
        if (SCANNED_CHUNKS.contains(chunkPosition)) {
            return;
        }
        SCANNED_CHUNKS.add(chunkPosition);
        for (Entity entity : chunk.getEntities()) {
            CustomMob customMob = CustomMob.getByEntity(entity);
            if (customMob != null) {
                customMob.cacheEntity(entity);
            }
            if (!(entity instanceof FallingBlock) || !GhostBlock.isGhostBlock(entity)) continue;
            GhostBlock.BLOCK_CACHE.add(entity.getUniqueId());
        }
    }
}

