/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.materials;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemHandler;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GhostBlock
extends SlimefunItem {
    public static final NamespacedKey KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "ghost_block");
    public static final Set<Material> EXCLUDED = Set.of(Material.BARRIER, Material.SPAWNER, Material.COMMAND_BLOCK, Material.STRUCTURE_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.JIGSAW);
    public static final Set<UUID> BLOCK_CACHE = new HashSet<UUID>();
    @Nonnull
    private final Material material;

    public GhostBlock(SlimefunItemStack item) {
        super((ItemGroup)Items.GHOST_BLOCKS_ITEM_GROUP, item, RecipeType.ENHANCED_CRAFTING_TABLE, new ItemStack[]{SlimefunItems.BILLON_INGOT, SlimefunItems.BILLON_INGOT, SlimefunItems.BILLON_INGOT, SlimefunItems.MAGICAL_GLASS, new ItemStack(item.getType()), SlimefunItems.MAGICAL_GLASS, SlimefunItems.BILLON_INGOT, SlimefunItems.BILLON_INGOT, SlimefunItems.BILLON_INGOT});
        this.material = item.getType();
    }

    public void preRegister() {
        this.addItemHandler(new ItemHandler[]{this.onUse()});
    }

    @Nonnull
    private ItemUseHandler onUse() {
        return e -> {
            e.cancel();
            if (e.getClickedBlock().isEmpty()) {
                return;
            }
            Player p = e.getPlayer();
            Block b = ((Block)e.getClickedBlock().get()).getRelative(e.getClickedFace());
            if (!Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b, Interaction.PLACE_BLOCK)) {
                p.sendMessage(ChatColor.LIGHT_PURPLE + "You don't have permission to place this here!");
                return;
            }
            if (!b.getWorld().getNearbyEntities(b.getLocation().add(0.5, 0.0, 0.5), 0.01, 0.01, 0.01).isEmpty()) {
                return;
            }
            FallingBlock block = b.getWorld().spawnFallingBlock(b.getLocation().add(0.5, 0.0, 0.5), this.material.createBlockData());
            block.setVelocity(new Vector(0, 0, 0));
            block.setGravity(false);
            block.setDropItem(false);
            block.setPersistent(true);
            block.setInvulnerable(true);
            block.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)"true");
            ItemStack item = e.getInteractEvent().getItem();
            item.setAmount(item.getAmount() - 1);
            BLOCK_CACHE.add(block.getUniqueId());
        };
    }

    public static boolean isGhostBlock(Entity entity) {
        return entity.getPersistentDataContainer().has(KEY, PersistentDataType.STRING);
    }
}

