/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.abstracts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.plugin.Plugin;

public abstract class CustomBoss
extends CustomMob {
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "boss");
    private static final Map<LivingEntity, BossBar> instances = new HashMap<LivingEntity, BossBar>();
    private final Set<EntityDamageEvent.DamageCause> resistances;

    protected CustomBoss(@Nonnull String id, @Nonnull String name, @Nonnull EntityType type, int health, EntityDamageEvent.DamageCause ... resistances) {
        super(id, name, type, health);
        this.resistances = Set.of(resistances);
    }

    @Nonnull
    protected abstract BossBarStyle getBossBarStyle();

    protected int getBossBarDistance() {
        return 30;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onSpawn(@Nonnull LivingEntity spawned) {
        BossBarStyle style = this.getBossBarStyle();
        KeyedBossBar bossbar = Bukkit.createBossBar((NamespacedKey)KEY, (String)style.name, (BarColor)style.color, (BarStyle)style.style, (BarFlag[])style.flags);
        bossbar.setVisible(true);
        bossbar.setProgress(1.0);
        spawned.setRemoveWhenFarAway(false);
        instances.put(spawned, (BossBar)bossbar);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onMobTick(@Nonnull LivingEntity mob, int tick) {
        if (tick == 100) {
            this.onBossPattern(mob);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public final void onHit(@Nonnull EntityDamageEvent event) {
        Entity entity;
        this.onBossDamaged(event);
        if (!event.isCancelled() && (entity = event.getEntity()) instanceof LivingEntity) {
            Entity entity2;
            LivingEntity entity3 = (LivingEntity)entity;
            BossBar bossbar = this.getBossBarForEntity(entity3);
            if (entity3.isInsideVehicle() && (entity2 = entity3.getVehicle()) instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity2;
                double finalHealth = entity3.getHealth() + vehicle.getHealth() - event.getFinalDamage();
                if (finalHealth > 0.0) {
                    bossbar.setProgress(Math.min(finalHealth / (entity3.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() + vehicle.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()), 1.0));
                }
            } else {
                double finalHealth = entity3.getHealth() - event.getFinalDamage();
                if (finalHealth > 0.0) {
                    bossbar.setProgress(Math.min(finalHealth / entity3.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue(), 1.0));
                }
            }
        }
    }

    @OverridingMethodsMustInvokeSuper
    protected void onBossDamaged(@Nonnull EntityDamageEvent e) {
        if (this.resistances.contains(e.getCause())) {
            e.setCancelled(true);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void onDeath(@Nonnull EntityDeathEvent event) {
        super.onDeath(event);
        BossBar bossbar = this.getBossBarForEntity(event.getEntity());
        bossbar.setVisible(false);
        bossbar.removeAll();
    }

    @OverridingMethodsMustInvokeSuper
    public void onBossPattern(@Nonnull LivingEntity mob) {
        Location l = mob.getLocation();
        long dist = (long)this.getBossBarDistance() * (long)this.getBossBarDistance();
        BossBar bossbar = this.getBossBarForEntity(mob);
        List players = bossbar.getPlayers();
        for (Player player : mob.getWorld().getPlayers()) {
            double distSquared = l.distanceSquared(player.getLocation());
            if (distSquared <= (double)dist && !players.contains(player)) {
                bossbar.addPlayer(player);
                continue;
            }
            if (!(distSquared > (double)dist) || !players.contains(player)) continue;
            bossbar.removePlayer(player);
        }
    }

    @Nonnull
    protected final BossBar getBossBarForEntity(LivingEntity entity) {
        Entity entity2;
        if (instances.containsKey(entity)) {
            return instances.get(entity);
        }
        BossBarStyle style = this.getBossBarStyle();
        KeyedBossBar bossbar = Bukkit.createBossBar((NamespacedKey)KEY, (String)style.name, (BarColor)style.color, (BarStyle)style.style, (BarFlag[])style.flags);
        bossbar.setVisible(true);
        if (entity.isInsideVehicle() && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            bossbar.setProgress(Math.min((entity.getHealth() + vehicle.getHealth()) / (entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() + vehicle.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()), 1.0));
        } else {
            bossbar.setProgress(Math.min(entity.getHealth() / entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue(), 1.0));
        }
        instances.put(entity, (BossBar)bossbar);
        return bossbar;
    }

    public static void removeBossBars() {
        for (BossBar bossbar : instances.values()) {
            bossbar.setVisible(false);
            bossbar.removeAll();
        }
    }

    public void updateBossBar(LivingEntity entity, double progress) {
        BossBar bossbar = this.getBossBarForEntity(entity);
        bossbar.setProgress(progress);
    }

    public record BossBarStyle(String name, BarColor color, BarStyle style, BarFlag[] flags) {
    }
}

