/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiddenSkeletonHorse
extends CustomMob {
    private static final Set<EntityDamageEvent.DamageCause> RESISTANCES = Set.of(EntityDamageEvent.DamageCause.CRAMMING, EntityDamageEvent.DamageCause.POISON, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION);

    public RiddenSkeletonHorse() {
        super("SKELETON_HORSE", "Skeleton Horse", EntityType.SKELETON_HORSE, 132);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        spawned.setCustomName("");
        spawned.setCustomNameVisible(false);
        spawned.setRemoveWhenFarAway(false);
        spawned.getAttribute(Attribute.GENERIC_ARMOR).setBaseValue(30.0);
        spawned.addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, 999999999, 4, false, false));
    }

    @Override
    protected void onHit(@Nonnull EntityDamageEvent event) {
        if (RESISTANCES.contains(event.getCause())) {
            event.setCancelled(true);
        }
        SkeletonHorse horse = (SkeletonHorse)event.getEntity();
        if (event.isCancelled()) {
            return;
        }
        for (Entity entity : horse.getPassengers()) {
            Object object = entity;
            if (!(object instanceof LivingEntity)) continue;
            LivingEntity passenger = (LivingEntity)object;
            object = CustomMob.getByEntity(entity);
            if (!(object instanceof CustomBoss)) continue;
            CustomBoss boss = (CustomBoss)object;
            double finalHealth = horse.getHealth() + passenger.getHealth() - event.getFinalDamage();
            if (!(finalHealth > 0.0)) continue;
            boss.updateBossBar(passenger, finalHealth / (passenger.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() + horse.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue()));
        }
    }

    @Override
    protected void onDeath(@Nonnull EntityDeathEvent event) {
        super.onDeath(event);
        event.getDrops().clear();
        List passengers = event.getEntity().getPassengers();
        for (Entity passenger : passengers) {
            Entity entity = passenger;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.setHealth(0.0);
        }
    }
}

