/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import me.gallowsdove.foxymachines.infinitylib.common.Scheduler;
import me.gallowsdove.foxymachines.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HeadlessHorseman
extends CustomBoss {
    private static final NamespacedKey PATTERN_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "pattern");

    public HeadlessHorseman() {
        super("HEADLESS_HORSEMAN", ChatColor.RED + "Headless Horseman", EntityType.SKELETON, 1, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.THORNS);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        super.onSpawn(spawned);
        spawned.setInvisible(true);
        CustomMob mob = CustomMob.getById("SKELETON_HORSE");
        SkeletonHorse horse = (SkeletonHorse)mob.spawn(spawned.getLocation());
        horse.addPassenger((Entity)spawned);
        EntityEquipment equipment = spawned.getEquipment();
        equipment.setArmorContents(new ItemStack[]{new ItemStack(Material.NETHERITE_BOOTS), new ItemStack(Material.NETHERITE_LEGGINGS), new ItemStack(Material.NETHERITE_CHESTPLATE), new ItemStack(Material.CARVED_PUMPKIN)});
        spawned.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(28.0);
        spawned.getPersistentDataContainer().set(PATTERN_KEY, PersistentDataType.SHORT, (Object)0);
    }

    @Override
    @Nonnull
    protected CustomBoss.BossBarStyle getBossBarStyle() {
        return new CustomBoss.BossBarStyle("Headless Horseman", BarColor.RED, BarStyle.SOLID, BarFlag.PLAY_BOSS_MUSIC);
    }

    @Override
    protected void onTarget(@Nonnull EntityTargetEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void onAttack(@Nonnull EntityDamageByEntityEvent event) {
        if (!event.isCancelled()) {
            Utils.dealDamageBypassingArmor((LivingEntity)event.getEntity(), (event.getDamage() - event.getFinalDamage()) * 0.12);
        }
    }

    @Override
    public void onBossPattern(@Nonnull LivingEntity mob) {
        super.onBossPattern(mob);
        short pattern = (short)ThreadLocalRandom.current().nextInt(7);
        if (pattern < 2) {
            pattern = 0;
        } else if (pattern < 5) {
            pattern = 1;
            Entity entity = mob.getVehicle();
            if (entity instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity;
                vehicle.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 100));
            }
        } else {
            pattern = 2;
        }
        PersistentDataAPI.setShort((PersistentDataHolder)mob, (NamespacedKey)PATTERN_KEY, (short)pattern);
    }

    @Override
    public void onBossDamaged(@Nonnull EntityDamageEvent event) {
        super.onBossDamaged(event);
        Skeleton headlessHorseman = (Skeleton)event.getEntity();
        if (headlessHorseman.isInsideVehicle()) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onMobTick(@Nonnull LivingEntity entity, int tick) {
        super.onMobTick(entity, tick);
        Skeleton headlessHorseman = (Skeleton)entity;
        short pattern = PersistentDataAPI.getShort((PersistentDataHolder)entity, (NamespacedKey)PATTERN_KEY);
        if ((tick + 4) % 5 == 0) {
            headlessHorseman.setTarget((LivingEntity)Utils.getNearbyPlayerInSurvival(headlessHorseman.getLocation(), 30.0, 20.0, 30.0));
        }
        if (pattern == 2 && tick == 25) {
            this.spawnHelldogs(headlessHorseman.getLocation());
            return;
        }
        LivingEntity target = headlessHorseman.getTarget();
        LivingEntity livingEntity = target;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (tick % 5 == 0 && pattern == 1) {
            Arrow arrow = (Arrow)entity.launchProjectile(Arrow.class);
            arrow.setDamage(22.0);
            arrow.setColor(Color.RED);
            arrow.setGlowing(true);
            arrow.setSilent(true);
            arrow.setGravity(false);
            arrow.setPersistent(false);
            try {
                arrow.setVelocity(target.getLocation().toVector().subtract(headlessHorseman.getLocation().toVector()).normalize().multiply(1.64));
            }
            catch (IllegalArgumentException ignored) {
                arrow.remove();
            }
            return;
        }
        if (tick % 8 == 0 && pattern == 0) {
            Location horsemanLocation;
            Location playerLocation = player.getLocation().clone();
            if (playerLocation.distanceSquared(horsemanLocation = headlessHorseman.getLocation()) >= Math.pow(26.0, 2.0)) {
                return;
            }
            Scheduler.run(4, () -> {
                playerLocation.getWorld().strikeLightningEffect(playerLocation);
                if (!player.isValid()) {
                    return;
                }
                Location newLocation = player.getLocation();
                if (Math.pow(playerLocation.getX() - newLocation.getX(), 2.0) + Math.pow(playerLocation.getY() - newLocation.getY(), 2.0) >= Math.pow(0.72, 2.0)) {
                    return;
                }
                EntityDamageEvent event = new EntityDamageEvent((Entity)player, EntityDamageEvent.DamageCause.CUSTOM, 12.0);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    player.damage(12.4);
                    Utils.dealDamageBypassingArmor((LivingEntity)player, 1.72);
                }
            });
        }
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent event) {
        super.onDeath(event);
        event.getDrops().clear();
        Location location = event.getEntity().getLocation();
        location.getWorld().dropItemNaturally(location, (ItemStack)new SlimefunItemStack(Items.VILE_PUMPKIN, 1));
        ((ExperienceOrb)location.getWorld().spawn(location, ExperienceOrb.class)).setExperience(2000 + ThreadLocalRandom.current().nextInt(800));
    }

    private void spawnHelldogs(Location location) {
        int i;
        CustomMob helldog = CustomMob.getById("HELLDOG");
        if (helldog == null) {
            FoxyMachines.getInstance().getLogger().warning("Could not spawn Helldogs! Please report this to the github!");
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (i = 0; i < 3; ++i) {
            helldog.spawn(new Location(location.getWorld(), location.getX() + random.nextDouble(-1.0, 1.0), location.getY() + random.nextDouble(0.6, 1.2), location.getZ() + random.nextDouble(-1.0, 1.0)));
        }
        for (i = 0; i < 20; ++i) {
            location.getWorld().spawnParticle(Particle.FLAME, location, 1, random.nextDouble(-1.5, 1.5), random.nextDouble(-1.2, 2.4), random.nextDouble(-1.5, 1.5), 0.0);
        }
    }

    public static class AttackPattern {
        public static final short LIGHTNING = 0;
        public static final short SHOOT = 1;
        public static final short SUMMON = 2;
    }
}

