/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Utils {
    private Utils() {
    }

    public static boolean isAuraSkillsLoaded() {
        return Bukkit.getPluginManager().isPluginEnabled("AuraSkills");
    }

    public static void dealDamageBypassingArmor(LivingEntity entity, double damage) {
        if (damage >= 0.0) {
            if (entity.getAbsorptionAmount() >= 0.0) {
                if (entity.getAbsorptionAmount() - damage > 0.0) {
                    entity.setAbsorptionAmount(entity.getAbsorptionAmount() - damage);
                    damage = 0.0;
                } else {
                    entity.setAbsorptionAmount(0.0);
                    damage -= entity.getAbsorptionAmount();
                }
            }
            if (damage > 0.0) {
                if (entity.getHealth() - damage >= 0.0) {
                    entity.setHealth(entity.getHealth() - damage);
                } else {
                    entity.setHealth(0.0);
                }
            }
        }
    }

    public static int countItemInInventory(@Nonnull Inventory inventory, @Nonnull ItemStack itemStack) {
        int amount = 0;
        for (ItemStack item : inventory.getContents()) {
            if (!itemStack.isSimilar(item)) continue;
            amount += item.getAmount();
        }
        return amount;
    }

    public static boolean isWithinBox(Location centerLocation, Location location, double radius) {
        return Utils.isWithinBox(centerLocation, location, radius, radius, radius);
    }

    public static boolean isWithinBox(Location centerLocation, Location location, double x, double y, double z) {
        return Math.abs(centerLocation.getX() - location.getX()) <= x && Math.abs(centerLocation.getY() - location.getY()) <= y && Math.abs(centerLocation.getZ() - location.getZ()) <= z;
    }

    public static List<Player> getNearbyPlayersInSurvival(Location location, double radius) {
        return Utils.getNearbyPlayersInSurvival(location, radius, radius, radius);
    }

    public static List<Player> getNearbyPlayersInSurvival(Location location, double x, double y, double z) {
        World world = location.getWorld();
        if (world == null) {
            return new ArrayList<Player>();
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : world.getNearbyEntities(location, x, y, z)) {
            Player player;
            Entity entity2 = entity;
            if (!(entity2 instanceof Player) || (player = (Player)entity2).getGameMode() != GameMode.SURVIVAL) continue;
            players.add(player);
        }
        return players;
    }

    public static Player getNearbyPlayerInSurvival(Location location, double radius) {
        return Utils.getNearbyPlayerInSurvival(location, radius, radius, radius);
    }

    @Nullable
    public static Player getNearbyPlayerInSurvival(Location location, double x, double y, double z) {
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        for (Entity entity : world.getNearbyEntities(location, x, y, z)) {
            Player player;
            Entity entity2 = entity;
            if (!(entity2 instanceof Player) || (player = (Player)entity2).getGameMode() != GameMode.SURVIVAL) continue;
            return player;
        }
        return null;
    }
}

