/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.mobs;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.abstracts.CustomBoss;
import me.gallowsdove.foxymachines.abstracts.CustomMob;
import me.gallowsdove.foxymachines.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vex;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PixieQueen
extends CustomBoss {
    private static final NamespacedKey PATTERN_KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "pattern");

    public PixieQueen() {
        super("PIXIE_QUEEN", ChatColor.GREEN + "Pixie Queen", EntityType.VEX, 800, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.THORNS);
    }

    @Override
    public void onSpawn(@Nonnull LivingEntity spawned) {
        super.onSpawn(spawned);
        spawned.setGlowing(true);
        spawned.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(28.0);
        spawned.getPersistentDataContainer().set(PATTERN_KEY, PersistentDataType.SHORT, (Object)0);
    }

    @Override
    @Nonnull
    protected CustomBoss.BossBarStyle getBossBarStyle() {
        return new CustomBoss.BossBarStyle("Pixie Queen", BarColor.GREEN, BarStyle.SOLID, BarFlag.PLAY_BOSS_MUSIC);
    }

    @Override
    protected void onTarget(@Nonnull EntityTargetEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void onAttack(@Nonnull EntityDamageByEntityEvent event) {
        if (!event.isCancelled()) {
            Utils.dealDamageBypassingArmor((LivingEntity)event.getEntity(), (event.getDamage() - event.getFinalDamage()) * 0.12);
        }
    }

    @Override
    public void onBossPattern(@Nonnull LivingEntity mob) {
        super.onBossPattern(mob);
        int pattern = ThreadLocalRandom.current().nextInt(7);
        if (pattern < 2) {
            pattern = 0;
        } else if (pattern < 4) {
            pattern = 1;
            mob.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 100));
        } else {
            pattern = pattern < 6 ? 2 : 3;
        }
        PersistentDataAPI.setShort((PersistentDataHolder)mob, (NamespacedKey)PATTERN_KEY, (short)pattern);
    }

    @Override
    public void onMobTick(@Nonnull LivingEntity entity, int tick) {
        super.onMobTick(entity, tick);
        Vex pixieQueen = (Vex)entity;
        short pattern = PersistentDataAPI.getShort((PersistentDataHolder)entity, (NamespacedKey)PATTERN_KEY);
        if (pattern == 2 && tick == 25) {
            this.summonPixieSwarm(pixieQueen.getLocation());
            return;
        }
        if (pattern == 0) {
            Location location = pixieQueen.getLocation();
            if (tick % 10 == 0) {
                List<Player> players = Utils.getNearbyPlayersInSurvival(location, 1.6);
                for (Player player : players) {
                    pixieQueen.attack((Entity)player);
                }
            }
            Player player = Utils.getNearbyPlayerInSurvival(location, 10.0);
            pixieQueen.setCharging(false);
            pixieQueen.setTarget((LivingEntity)player);
            if (player == null) {
                return;
            }
            if ((tick + 2) % 3 == 0) {
                try {
                    pixieQueen.setVelocity(player.getLocation().toVector().subtract(location.toVector()).normalize().multiply(0.32));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return;
        }
        if (pattern == 1) {
            pixieQueen.setCharging(false);
            if (tick % 5 == 0 && pixieQueen.getTarget() != null) {
                Arrow arrow = (Arrow)entity.launchProjectile(Arrow.class);
                arrow.setDamage(24.0);
                arrow.setColor(Color.LIME);
                arrow.setGlowing(true);
                arrow.setSilent(true);
                arrow.setGravity(false);
                arrow.setPersistent(false);
                try {
                    arrow.setVelocity(pixieQueen.getTarget().getLocation().toVector().subtract(pixieQueen.getLocation().toVector()).normalize().multiply(1.42));
                }
                catch (IllegalArgumentException ignored) {
                    arrow.remove();
                }
            }
        }
    }

    @Override
    public void onDeath(@Nonnull EntityDeathEvent event) {
        super.onDeath(event);
        event.getDrops().clear();
        Location loc = event.getEntity().getLocation();
        loc.getWorld().dropItemNaturally(loc, (ItemStack)new SlimefunItemStack(Items.PIXIE_QUEEN_HEART, 1));
        ((ExperienceOrb)loc.getWorld().spawn(loc, ExperienceOrb.class)).setExperience(1400 + ThreadLocalRandom.current().nextInt(600));
    }

    private void summonPixieSwarm(Location location) {
        int i;
        CustomMob mob = CustomMob.getById("PIXIE");
        if (mob == null) {
            FoxyMachines.getInstance().getLogger().warning("Could not spawn Pixies! Please report this to the github!");
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (i = 0; i < random.nextInt(2) + 3; ++i) {
            mob.spawn(new Location(location.getWorld(), location.getX() + random.nextDouble(-2.0, 2.0), location.getY() + random.nextDouble(1.2, 2.4), location.getZ() + random.nextDouble(-2.0, 2.0)));
        }
        for (i = 0; i < 10; ++i) {
            location.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, location, 1, random.nextDouble(-1.5, 1.5), random.nextDouble(-1.2, 2.4), random.nextDouble(-1.5, 1.5), 0.0);
        }
    }

    public static class AttackPattern {
        public static final short CHARGE = 0;
        public static final short SHOOT = 1;
        public static final short SUMMON = 2;
        public static final short IDLE = 3;
    }
}

