/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.consumables;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.Items;
import me.gallowsdove.foxymachines.infinitylib.common.Scheduler;
import me.gallowsdove.foxymachines.infinitylib.core.AddonConfig;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UnbreakableRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final Map<String, Set<String>> BLACKLIST = new HashMap<String, Set<String>>();
    private static final double RANGE = 1.5;

    public static void init() {
        if (!BLACKLIST.isEmpty()) {
            FoxyMachines.log(Level.WARNING, "Attempted to initialize UnbreakableRune after already initialized!");
            return;
        }
        AddonConfig config = FoxyMachines.getInstance().getConfig();
        ConfigurationSection blacklist = config.getConfigurationSection("unbreakable-rune-blacklist");
        if (blacklist == null) {
            return;
        }
        for (String addon : blacklist.getKeys(false)) {
            BLACKLIST.put(addon, new HashSet(blacklist.getStringList(addon)));
        }
    }

    public UnbreakableRune() {
        super((ItemGroup)Items.TOOLS_ITEM_GROUP, Items.UNBREAKABLE_RUNE, RecipeType.ANCIENT_ALTAR, new ItemStack[]{Items.DAMIENIUM, Items.MAGIC_LUMP_5, Items.DAMIENIUM, SlimefunItems.ESSENCE_OF_AFTERLIFE, SlimefunItems.LIGHTNING_RUNE, SlimefunItems.ESSENCE_OF_AFTERLIFE, Items.DAMIENIUM, Items.MAGIC_LUMP_5, Items.DAMIENIUM});
    }

    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (!SlimefunUtils.canPlayerUseItem((Player)p, (ItemStack)Items.UNBREAKABLE_RUNE, (boolean)true)) {
                    return true;
                }
                Scheduler.run(20, () -> this.activate(p, item));
                return true;
            }
            return false;
        };
    }

    private void activate(@Nonnull Player p, @Nonnull Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entities = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, entity -> this.findCompatibleItem(p, (Entity)entity));
        Optional optional = entities.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                Scheduler.run(10, () -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().createExplosion(l, 0.0f);
                        l.getWorld().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        item.remove();
                        rune.remove();
                        UnbreakableRune.setUnbreakable(itemStack);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item is now Unbreakable.");
                    } else {
                        p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item could not be made Unbreakable");
                    }
                });
            } else {
                p.sendMessage(ChatColor.LIGHT_PURPLE + "Your item could not be made Unbreakable");
            }
        }
    }

    private boolean findCompatibleItem(Player player, Entity entity) {
        Entity entity2 = entity;
        if (entity2 instanceof Item) {
            Item item = (Item)entity2;
            ItemStack itemStack = item.getItemStack();
            return !UnbreakableRune.isUnbreakable(itemStack) && !this.isItem(itemStack) && !UnbreakableRune.isDisallowed(player, itemStack);
        }
        return false;
    }

    public static void setUnbreakable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR && !UnbreakableRune.isUnbreakable(item) && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            meta.setUnbreakable(true);
            item.setItemMeta(meta);
        }
    }

    public static boolean isUnbreakable(@Nullable ItemStack item) {
        if (item != null && item.getType() != Material.AIR) {
            if (item.hasItemMeta()) {
                return item.getItemMeta().isUnbreakable();
            }
            return false;
        }
        return false;
    }

    public static boolean isDisallowed(Player player, ItemStack itemStack) {
        SlimefunItem slimefunItem = SlimefunItem.getByItem((ItemStack)itemStack);
        if (slimefunItem == null) {
            return false;
        }
        String id = slimefunItem.getId();
        String addon = slimefunItem.getAddon().getName();
        if (BLACKLIST.containsKey(addon) && BLACKLIST.get(addon).contains(id)) {
            player.sendMessage(ChatColor.LIGHT_PURPLE + "You can't make this item unbreakable!");
            return true;
        }
        return false;
    }
}

