/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.abstracts;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.data.persistent.PersistentDataAPI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.ParametersAreNonnullByDefault;
import me.gallowsdove.foxymachines.FoxyMachines;
import me.gallowsdove.foxymachines.infinitylib.common.Events;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class CustomMob {
    public static final Map<String, CustomMob> MOBS = new HashMap<String, CustomMob>();
    public static final Map<CustomMob, Set<UUID>> MOB_CACHE = new HashMap<CustomMob, Set<UUID>>();
    private static final NamespacedKey KEY = new NamespacedKey((Plugin)FoxyMachines.getInstance(), "mob");
    @Nonnull
    private final String id;
    @Nonnull
    private final String name;
    @Nonnull
    private final EntityType type;
    private final int health;

    @Nullable
    public static CustomMob getById(@Nonnull String id) {
        return MOBS.get(id);
    }

    @Nullable
    public static CustomMob getByEntity(@Nonnull Entity entity) {
        String id = PersistentDataAPI.getString((PersistentDataHolder)entity, (NamespacedKey)KEY);
        return id == null ? null : CustomMob.getById(id);
    }

    @ParametersAreNonnullByDefault
    protected CustomMob(String id, String name, EntityType type, int health) {
        this.id = id;
        Validate.notNull((Object)this.id);
        this.name = ChatColors.color((String)name);
        Validate.notNull((Object)this.name);
        this.type = type;
        Validate.notNull((Object)this.type);
        Validate.isTrue((boolean)type.isAlive(), (String)("Entity type " + type + " is not alive!"));
        this.health = health;
        Validate.isTrue((this.health > 0 ? 1 : 0) != 0);
        Validate.notNull((Object)this.getSpawnOffset());
        MOBS.put(id, this);
    }

    @Nonnull
    public final LivingEntity spawn(@Nonnull Location loc) {
        LivingEntity entity = (LivingEntity)loc.getWorld().spawnEntity(loc, this.type);
        PersistentDataAPI.setString((PersistentDataHolder)entity, (NamespacedKey)KEY, (String)this.id);
        Objects.requireNonNull(entity.getAttribute(Attribute.GENERIC_MAX_HEALTH)).setBaseValue((double)this.health);
        entity.setHealth((double)this.health);
        entity.setCustomName(this.name);
        entity.setCustomNameVisible(true);
        entity.setRemoveWhenFarAway(true);
        this.onSpawn(entity);
        this.cacheEntity((Entity)entity);
        return entity;
    }

    public void onUniqueTick(int tick) {
    }

    protected void onSpawn(@Nonnull LivingEntity spawned) {
    }

    public void onMobTick(@Nonnull LivingEntity mob, int tick) {
    }

    protected void onHit(@Nonnull EntityDamageEvent event) {
    }

    protected void onAttack(@Nonnull EntityDamageByEntityEvent event) {
    }

    protected void onInteract(@Nonnull PlayerInteractEntityEvent event) {
    }

    protected void onTarget(@Nonnull EntityTargetEvent event) {
    }

    @OverridingMethodsMustInvokeSuper
    protected void onDeath(@Nonnull EntityDeathEvent event) {
        this.uncacheEntity((Entity)event.getEntity());
    }

    protected void onCastSpell(@Nonnull EntitySpellCastEvent event) {
    }

    protected void onDamage(@Nonnull EntityDamageEvent event) {
    }

    protected Vector getSpawnOffset() {
        return new Vector();
    }

    public void cacheEntity(@Nonnull Entity entity) {
        this.cacheEntity(entity.getUniqueId());
    }

    public void cacheEntity(@Nonnull UUID uuid) {
        Set entities = MOB_CACHE.getOrDefault(this, new HashSet());
        entities.add(uuid);
        MOB_CACHE.put(this, entities);
    }

    public void uncacheEntity(@Nonnull Entity entity) {
        this.uncacheEntity(entity.getUniqueId());
    }

    public void uncacheEntity(@Nonnull UUID uuid) {
        Set entities = MOB_CACHE.getOrDefault(this, new HashSet());
        entities.remove(uuid);
        MOB_CACHE.put(this, entities);
    }

    public static void debug() {
        Bukkit.broadcastMessage((String)"CACHE:");
        for (Map.Entry<CustomMob, Set<UUID>> entry : MOB_CACHE.entrySet()) {
            Bukkit.broadcastMessage((String)(entry.getKey().getId() + " (" + entry.getValue().size() + ")\n" + entry.getValue().stream().map(UUID::toString).collect(Collectors.joining("\n"))));
        }
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public EntityType getType() {
        return this.type;
    }

    static {
        Events.registerListener(new Listener(){

            @EventHandler
            public void onTarget(@Nonnull EntityTargetEvent event) {
                CustomMob customMob = CustomMob.getByEntity(event.getEntity());
                if (customMob != null) {
                    customMob.onTarget(event);
                }
            }

            @EventHandler
            public void onInteract(@Nonnull PlayerInteractEntityEvent event) {
                CustomMob customMob = CustomMob.getByEntity(event.getRightClicked());
                if (customMob != null) {
                    customMob.onInteract(event);
                }
            }

            @EventHandler
            public void onHit(@Nonnull EntityDamageByEntityEvent event) {
                CustomMob customMob = CustomMob.getByEntity(event.getDamager());
                if (customMob != null) {
                    customMob.onAttack(event);
                }
            }

            @EventHandler
            public void onDamaged(@Nonnull EntityDamageEvent event) {
                CustomMob customMob = CustomMob.getByEntity(event.getEntity());
                if (customMob != null) {
                    customMob.onHit(event);
                }
            }

            @EventHandler
            public void onDeath(@Nonnull EntityDeathEvent event) {
                CustomMob customMob = CustomMob.getByEntity((Entity)event.getEntity());
                if (customMob != null) {
                    customMob.onDeath(event);
                }
            }

            @EventHandler
            public void onSpellCast(@Nonnull EntitySpellCastEvent event) {
                CustomMob customMob = CustomMob.getByEntity((Entity)event.getEntity());
                if (customMob != null) {
                    customMob.onCastSpell(event);
                }
            }

            @EventHandler
            public void onDamage(@Nonnull EntityDamageEvent event) {
                CustomMob customMob = CustomMob.getByEntity(event.getEntity());
                if (customMob != null) {
                    customMob.onDamage(event);
                }
            }

            @EventHandler(ignoreCancelled=true)
            private void onNametagEvent(PlayerInteractEntityEvent event) {
                ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
                if (item.getType() == Material.NAME_TAG && CustomMob.getByEntity(event.getRightClicked()) != null) {
                    event.setCancelled(true);
                }
            }

            @EventHandler(ignoreCancelled=true)
            private void onCombust(EntityCombustEvent event) {
                if (CustomMob.getByEntity(event.getEntity()) != null) {
                    event.setCancelled(true);
                }
            }
        });
    }
}

