/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.implementation.materials;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import javax.annotation.Nonnull;
import me.gallowsdove.foxymachines.listeners.SacrificialAltarListener;
import me.gallowsdove.foxymachines.utils.QuestUtils;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;

public class ShardMaterial
extends SimpleSlimefunItem<ItemDropHandler> {
    private final ChatColor color;

    public ShardMaterial(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ChatColor color) {
        super(itemGroup, item, recipeType, recipe);
        this.color = color;
    }

    @Nonnull
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (!this.isItem(item.getItemStack())) {
                return false;
            }
            if (!QuestUtils.hasActiveQuest(p)) {
                return true;
            }
            Slimefun.runSync(() -> {
                if (SacrificialAltarListener.findAltar(item.getLocation().getBlock()) == null) {
                    return;
                }
                p.sendMessage(this.color + "Quest reset!");
                QuestUtils.resetQuestLine(p);
                SacrificialAltarListener.particleAnimation(item.getLocation());
                if (item.getItemStack().getAmount() == 1) {
                    item.remove();
                } else {
                    ItemStack i = item.getItemStack();
                    i.setAmount(i.getAmount() - 1);
                    item.setItemStack(i);
                }
            }, (long)20L);
            return true;
        };
    }
}

