/*
 * Decompiled with CFR 0.152.
 */
package me.gallowsdove.foxymachines.infinitylib.machines;

import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import java.util.HashMap;
import java.util.Map;
import me.gallowsdove.foxymachines.infinitylib.common.StackUtils;
import me.gallowsdove.foxymachines.infinitylib.machines.MachineInput;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.inventory.ItemStack;

final class MachineBlockRecipe {
    private final String[] strings;
    private final int[] amounts;
    final ItemStack output;
    private Map<String, MachineInput> lastMatch;

    MachineBlockRecipe(ItemStack output, ItemStack[] input) {
        this.output = output;
        HashMap<String, Integer> strings = new HashMap<String, Integer>();
        for (ItemStack item : input) {
            if (item == null || item.getType().isAir()) continue;
            String string = StackUtils.getId(item);
            if (string == null) {
                string = item.getType().name();
            }
            strings.compute(string, (k, v) -> v == null ? item.getAmount() : v + item.getAmount());
        }
        this.strings = strings.keySet().toArray(new String[0]);
        this.amounts = ArrayUtils.toPrimitive((Integer[])strings.values().toArray(new Integer[0]));
    }

    boolean check(Map<String, MachineInput> map) {
        for (int i = 0; i < this.strings.length; ++i) {
            MachineInput input = map.get(this.strings[i]);
            if (input != null && input.amount >= this.amounts[i]) continue;
            return false;
        }
        this.lastMatch = map;
        return true;
    }

    void consume() {
        block0: for (int i = 0; i < this.strings.length; ++i) {
            int consume = this.amounts[i];
            for (ItemStack item : this.lastMatch.get((Object)this.strings[i]).items) {
                int amt = item.getAmount();
                if (amt >= consume) {
                    ItemUtils.consumeItem((ItemStack)item, (int)consume, (boolean)true);
                    continue block0;
                }
                ItemUtils.consumeItem((ItemStack)item, (int)amt, (boolean)true);
                consume -= amt;
            }
        }
    }
}

